import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["role", "children", "paddingSize", "isLoading", "isLoadingMessage", "isOpen"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo, useState } from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { EuiResizeObserver } from '../../observer/resize_observer';
import { EuiAccordionChildrenLoading } from './accordion_children_loading';
import { euiAccordionChildrenStyles, euiAccordionChildWrapperStyles } from './accordion_children.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiAccordionChildren = function EuiAccordionChildren(_ref) {
  var role = _ref.role,
    children = _ref.children,
    paddingSize = _ref.paddingSize,
    isLoading = _ref.isLoading,
    isLoadingMessage = _ref.isLoadingMessage,
    isOpen = _ref.isOpen,
    rest = _objectWithoutProperties(_ref, _excluded);
  /**
   * Children
   */
  var classes = classNames('euiAccordion__children', {
    'euiAccordion__children-isLoading': isLoading
  });
  var euiTheme = useEuiTheme();
  var styles = euiAccordionChildrenStyles(euiTheme);
  var cssStyles = [styles.euiAccordion__children, isLoading && styles.isLoading, paddingSize && paddingSize !== 'none' && styles[paddingSize]];

  /**
   * Wrapper
   */
  var wrapperStyles = euiAccordionChildWrapperStyles(euiTheme);
  var wrapperCssStyles = [wrapperStyles.euiAccordion__childWrapper, isOpen ? wrapperStyles.isOpen : wrapperStyles.isClosed];

  /**
   * Update the accordion wrapper height whenever the accordion opens, and also
   * whenever the child content updates (which will change the height)
   */
  var _useState = useState(0),
    _useState2 = _slicedToArray(_useState, 2),
    contentHeight = _useState2[0],
    setContentHeight = _useState2[1];
  var onResize = useCallback(function (_ref2) {
    var height = _ref2.height;
    return setContentHeight(Math.round(height));
  }, []);
  var heightInlineStyle = useMemo(function () {
    return {
      blockSize: isOpen ? contentHeight : 0
    };
  }, [isOpen, contentHeight]);
  return ___EmotionJSX("div", _extends({}, rest, {
    className: "euiAccordion__childWrapper",
    css: wrapperCssStyles,
    style: heightInlineStyle,
    role: role
    // @ts-expect-error - inert property not yet available in React TS defs. TODO: Remove this once https://github.com/DefinitelyTyped/DefinitelyTyped/pull/60822 is merged
    ,
    inert: !isOpen ? '' : undefined // Can't pass a boolean currently, Jest throws errors
  }), ___EmotionJSX(EuiResizeObserver, {
    onResize: onResize
  }, function (resizeRef) {
    return ___EmotionJSX("div", {
      ref: resizeRef,
      className: classes,
      css: cssStyles
    }, isLoading && isLoadingMessage ? ___EmotionJSX(EuiAccordionChildrenLoading, {
      isLoadingMessage: isLoadingMessage
    }) : children);
  }));
};