import { css as _css } from "@emotion/react";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { useEuiTheme } from '../../../services';
import { EuiI18n } from '../../i18n';
import { EuiText } from '../../text';
import { EuiLoadingSpinner } from '../../loading';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiAccordionChildrenLoading = function EuiAccordionChildrenLoading(_ref) {
  var isLoadingMessage = _ref.isLoadingMessage;
  var _useEuiTheme = useEuiTheme(),
    euiTheme = _useEuiTheme.euiTheme;
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiLoadingSpinner, {
    className: "euiAccordion__spinner",
    css: /*#__PURE__*/_css({
      marginInlineEnd: euiTheme.size.xs
    }, ";label:EuiAccordionChildrenLoading;")
  }), ___EmotionJSX(EuiText, {
    size: "s"
  }, ___EmotionJSX("p", null, isLoadingMessage !== true ? isLoadingMessage : ___EmotionJSX(EuiI18n, {
    token: "euiAccordionChildrenLoading.message",
    default: "Loading"
  }))));
};