import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["arrowDisplay", "arrowProps", "isOpen"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { EuiButtonIcon } from '../../button';
import { euiAccordionArrowStyles } from './accordion_arrow.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiAccordionArrow = function EuiAccordionArrow(_ref) {
  var _ref$arrowDisplay = _ref.arrowDisplay,
    arrowDisplay = _ref$arrowDisplay === void 0 ? 'left' : _ref$arrowDisplay,
    arrowProps = _ref.arrowProps,
    isOpen = _ref.isOpen,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  if (arrowDisplay === 'none') return null;
  var styles = euiAccordionArrowStyles(euiTheme);
  var cssStyles = [styles.euiAccordion__arrow, styles[arrowDisplay], isOpen ? styles.isOpen : styles.isClosed, arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.css];
  var classes = classNames('euiAccordion__arrow', arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.className);
  return ___EmotionJSX(EuiButtonIcon, _extends({
    color: "text"
  }, arrowProps, rest, {
    className: classes,
    css: cssStyles,
    iconType: "arrowRight"
  }));
};