import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["buttonElement", "buttonProps", "buttonClassName", "buttonContentClassName", "isDisabled", "arrowDisplay", "children"],
  _excluded2 = ["paddingSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { euiAccordionButtonStyles } from './accordion_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiAccordionButton = function EuiAccordionButton(_ref) {
  var ButtonElement = _ref.buttonElement,
    _buttonProps = _ref.buttonProps,
    buttonClassName = _ref.buttonClassName,
    buttonContentClassName = _ref.buttonContentClassName,
    isDisabled = _ref.isDisabled,
    arrowDisplay = _ref.arrowDisplay,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _ref2 = _buttonProps || {},
    paddingSize = _ref2.paddingSize,
    buttonProps = _objectWithoutProperties(_ref2, _excluded2);
  var classes = classNames('euiAccordion__button', buttonClassName, buttonProps.className);
  var buttonContentClasses = classNames('euiAccordion__buttonContent', buttonContentClassName);
  var euiTheme = useEuiTheme();
  var styles = euiAccordionButtonStyles(euiTheme);
  var cssStyles = [styles.euiAccordion__button, isDisabled && styles.disabled].concat(_toConsumableArray(paddingSize ? [styles[paddingSize], arrowDisplay === 'left' && styles.arrowLeft, arrowDisplay === 'right' && styles.arrowRight] : []), [buttonProps.css]);
  var elementIsButton = ButtonElement === 'button';
  return ___EmotionJSX(ButtonElement, _extends({}, buttonProps, rest, {
    className: classes,
    css: cssStyles,
    type: elementIsButton ? 'button' : undefined,
    disabled: elementIsButton ? isDisabled : undefined
  }), ___EmotionJSX("span", {
    className: buttonContentClasses
  }, children));
};