import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "style", "height", "width", "maxWidth"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { logicalStyles } from '../../global_styling';
export var EuiAspectRatio = function EuiAspectRatio(_ref) {
  var children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    height = _ref.height,
    width = _ref.width,
    maxWidth = _ref.maxWidth,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiAspectRatio', className, children.props.className);
  var euiAspectRatioStyle = useMemo(function () {
    return logicalStyles({
      aspectRatio: "".concat(width, " / ").concat(height),
      height: 'auto',
      width: '100%',
      maxWidth: maxWidth
    });
  }, [height, width, maxWidth]);
  return /*#__PURE__*/React.cloneElement(children, _objectSpread(_objectSpread({}, rest), {}, {
    className: classes,
    style: _objectSpread(_objectSpread(_objectSpread({}, children.props.style), euiAspectRatioStyle), style)
  }));
};