import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "color", "imageUrl", "initials", "initialsLength", "iconType", "iconSize", "iconColor", "name", "size", "type", "isDisabled", "style"],
  _excluded2 = ["casing"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { isColorDark, hexToRgb, isValidHex } from '../../services/color';
import { euiPaletteColorBlindBehindText, toInitials, useEuiMemoizedStyles } from '../../services';
import { EuiIcon } from '../icon';
import { euiAvatarStyles } from './avatar.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var visColors = euiPaletteColorBlindBehindText();
export var SIZES = ['s', 'm', 'l', 'xl'];
export var TYPES = ['space', 'user'];
export var CASING = ['capitalize', 'uppercase', 'lowercase', 'none'];

/**
 * The avatar can only display one type of content,
 * initials, or image, or iconType
 */

export var EuiAvatar = function EuiAvatar(_ref) {
  var className = _ref.className,
    color = _ref.color,
    imageUrl = _ref.imageUrl,
    initials = _ref.initials,
    initialsLength = _ref.initialsLength,
    iconType = _ref.iconType,
    iconSize = _ref.iconSize,
    iconColor = _ref.iconColor,
    name = _ref.name,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'user' : _ref$type,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    style = _ref.style,
    props = _objectWithoutProperties(_ref, _excluded);
  checkValidInitials(initials);
  var _props$casing = props.casing,
    casing = _props$casing === void 0 ? type === 'space' ? 'none' : 'uppercase' : _props$casing,
    rest = _objectWithoutProperties(props, _excluded2);
  var isPlain = color === 'plain';
  var isSubdued = color === 'subdued';
  var isNamedColor = isPlain || isSubdued || color === null;
  var classes = classNames('euiAvatar', _defineProperty(_defineProperty(_defineProperty({}, "euiAvatar--".concat(size), size), "euiAvatar--".concat(type), type), 'euiAvatar-isDisabled', isDisabled), className);
  var styles = useEuiMemoizedStyles(euiAvatarStyles);
  var cssStyles = [styles.euiAvatar, styles[type], styles[size], styles[casing], isPlain && styles.plain, isSubdued && styles.subdued, isDisabled && styles.isDisabled];
  var avatarStyle = useMemo(function () {
    if (imageUrl) {
      return {
        backgroundImage: "url(".concat(imageUrl, ")")
      };
    }
    if (!isNamedColor) {
      checkValidColor(color);
      var assignedColor = color || visColors[Math.floor(name.length % visColors.length)];
      var textColor = isColorDark.apply(void 0, _toConsumableArray(hexToRgb(assignedColor))) ? '#FFFFFF' : '#000000';
      return {
        backgroundColor: assignedColor,
        color: textColor
      };
    }
  }, [imageUrl, color, isNamedColor, name.length]);
  var iconCustomColor = useMemo(function () {
    // `null` allows icons to keep their default color (e.g. app icons)
    if (iconColor === null) return undefined;
    // Otherwise continue to pass on `iconColor`
    if (iconColor) return iconColor;
    // Fall back to the adjusted text color if it exists
    return avatarStyle === null || avatarStyle === void 0 ? void 0 : avatarStyle.color;
  }, [iconColor, avatarStyle === null || avatarStyle === void 0 ? void 0 : avatarStyle.color]);
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes,
    style: _objectSpread(_objectSpread({}, style), avatarStyle),
    "aria-label": isDisabled ? undefined : name,
    role: isDisabled ? 'presentation' : 'img',
    title: name
  }, rest), !imageUrl && (iconType ? ___EmotionJSX(EuiIcon, {
    className: "euiAvatar__icon",
    size: iconSize || size,
    type: iconType,
    color: iconCustomColor
  }) : ___EmotionJSX("span", {
    "aria-hidden": "true"
  }, toInitials(name, initialsLength, initials))));
};

// TODO: Migrate to a service
export var checkValidColor = function checkValidColor(color) {
  var validHex = color && isValidHex(color) || color === 'plain' || color === 'subdued';
  if (color && !validHex) {
    throw new Error('EuiAvatar needs to pass a valid color. This can either be a three ' + 'or six character hex value');
  }
};
function checkValidInitials(initials) {
  // Must be a string of 1 or 2 characters
  if (initials && initials.length > 2) {
    console.warn('EuiAvatar only accepts a max of 2 characters for the initials as a string. It is displaying only the first 2 characters.');
  }
}