import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "color", "iconType", "iconSide", "className", "isDisabled", "onClick", "iconOnClick", "onClickAriaLabel", "iconOnClickAriaLabel", "closeButtonProps", "href", "rel", "target", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiTheme, useEuiMemoizedStyles, getSecureRelForTarget, wcagContrastMin } from '../../services';
import { validateHref } from '../../services/security/href_validator';
import { EuiInnerText } from '../inner_text';
import { EuiIcon } from '../icon';
import { getTextColor, getColorContrast, getIsValidColor } from './color_utils';
import { euiBadgeStyles } from './badge.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ICON_SIDES = ['left', 'right'];
export var COLORS = ['default', 'hollow', 'primary', 'success', 'accent', 'warning', 'danger'];
export var EuiBadge = function EuiBadge(_ref) {
  var children = _ref.children,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'default' : _ref$color,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'left' : _ref$iconSide,
    className = _ref.className,
    _isDisabled = _ref.isDisabled,
    onClick = _ref.onClick,
    iconOnClick = _ref.iconOnClick,
    onClickAriaLabel = _ref.onClickAriaLabel,
    iconOnClickAriaLabel = _ref.iconOnClickAriaLabel,
    closeButtonProps = _ref.closeButtonProps,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || validateHref(href);
  var isDisabled = _isDisabled || !isHrefValid;
  var isNamedColor = COLORS.includes(color);
  var euiTheme = useEuiTheme();
  var customColorStyles = useMemo(function () {
    // Disabled badges should not have custom colors
    if (isDisabled) return style;
    // Named colors set their styles via Emotion CSS and not inline styles
    if (isNamedColor) return style;

    // Do our best to ensure custom colors provide sufficient contrast
    try {
      // Set dark or light text color based upon best contrast
      var textColor = getTextColor(euiTheme, color);

      // Check the contrast ratio. If it's low contrast, emit a console awrning
      var contrastRatio = getColorContrast(textColor, color);
      if (contrastRatio < wcagContrastMin) {
        console.warn("Warning: ".concat(color, " badge has a low contrast of ").concat(contrastRatio.toFixed(2), ". Should be above ").concat(wcagContrastMin, "."));
      }
      return _objectSpread({
        '--euiBadgeBackgroundColor': color,
        '--euiBadgeTextColor': textColor
      }, style);
    } catch (err) {
      if (!getIsValidColor(color)) {
        console.warn('EuiBadge expects a valid color. This can either be a three or six ' + "character hex value, rgb(a) value, hsv value, hollow, or one of the following: ".concat(COLORS, ". ") + "Instead got ".concat(color, "."));
      }
    }
  }, [color, isNamedColor, isDisabled, style, euiTheme]);
  var styles = useEuiMemoizedStyles(euiBadgeStyles);
  var cssStyles = [styles.euiBadge].concat(_toConsumableArray(isDisabled ? [styles.disabled] : [isNamedColor && styles[color], !iconOnClick && (onClick || href) && styles.clickable]));
  var textCssStyles = [styles.text.euiBadge__text, (onClick || href) && !isDisabled && styles.text.clickable];
  var iconCssStyles = [styles.icon.euiBadge__icon, styles.icon[iconSide]];
  var iconButtonCssStyles = [styles.iconButton.euiBadge__iconButton, styles.iconButton[iconSide]];
  var classes = classNames('euiBadge', className);
  var closeClassNames = classNames('euiBadge__icon', closeButtonProps === null || closeButtonProps === void 0 ? void 0 : closeButtonProps.className);
  var Element = href && !isDisabled ? 'a' : 'button';
  var relObj = {};
  if (href && !isDisabled) {
    relObj.href = href;
    relObj.target = target;
    relObj.rel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
  }
  if (onClick) {
    relObj.onClick = onClick;
  }
  var optionalIcon = null;
  if (iconType) {
    if (iconOnClick) {
      if (!iconOnClickAriaLabel) {
        console.warn('When passing the iconOnClick props to EuiBadge, you must also provide iconOnClickAriaLabel');
      }
      optionalIcon = ___EmotionJSX("button", {
        type: "button",
        className: "euiBadge__iconButton",
        css: iconButtonCssStyles,
        "aria-label": iconOnClickAriaLabel,
        disabled: isDisabled,
        title: iconOnClickAriaLabel,
        onClick: iconOnClick
      }, ___EmotionJSX(EuiIcon, _extends({
        type: iconType,
        size: "s",
        color: "inherit" // forces the icon to inherit its parent color
      }, closeButtonProps, {
        className: closeClassNames,
        css: [].concat(iconCssStyles, [closeButtonProps === null || closeButtonProps === void 0 ? void 0 : closeButtonProps.css])
      })));
    } else {
      optionalIcon = ___EmotionJSX(EuiIcon, {
        type: iconType,
        size: children ? 's' : 'm',
        className: "euiBadge__icon",
        css: iconCssStyles,
        color: "inherit" // forces the icon to inherit its parent color
      });
    }
  }
  if (onClick && !onClickAriaLabel) {
    console.warn('When passing onClick to EuiBadge, you must also provide onClickAriaLabel');
  }
  var content = ___EmotionJSX("span", {
    className: "euiBadge__content",
    css: styles.euiBadge__content
  }, iconSide === 'left' && optionalIcon, children && ___EmotionJSX("span", {
    className: "euiBadge__text",
    css: textCssStyles
  }, children), iconSide === 'right' && optionalIcon);
  if (iconOnClick) {
    return onClick || href ? ___EmotionJSX("span", {
      className: classes,
      css: cssStyles,
      style: customColorStyles
    }, ___EmotionJSX("span", {
      className: "euiBadge__content",
      css: styles.euiBadge__content
    }, iconSide === 'left' && optionalIcon, ___EmotionJSX(EuiInnerText, null, function (ref, innerText) {
      return ___EmotionJSX(Element, _extends({
        className: "euiBadge__childButton",
        css: styles.euiBadge__childButton,
        disabled: isDisabled,
        "aria-label": onClickAriaLabel,
        ref: ref,
        title: innerText
      }, relObj, rest), children);
    }), iconSide === 'right' && optionalIcon)) : ___EmotionJSX(EuiInnerText, null, function (ref, innerText) {
      return ___EmotionJSX("span", _extends({
        className: classes,
        css: cssStyles,
        style: customColorStyles,
        ref: ref,
        title: innerText
      }, rest), content);
    });
  } else if (onClick || href) {
    return ___EmotionJSX(EuiInnerText, null, function (ref, innerText) {
      return ___EmotionJSX(Element, _extends({
        disabled: isDisabled,
        "aria-label": onClickAriaLabel,
        className: classes,
        css: cssStyles,
        style: customColorStyles,
        ref: ref,
        title: innerText
      }, relObj, rest), content);
    });
  } else {
    return ___EmotionJSX(EuiInnerText, null, function (ref, innerText) {
      return ___EmotionJSX("span", _extends({
        className: classes,
        css: cssStyles,
        style: customColorStyles,
        ref: ref,
        title: innerText
      }, rest), content);
    });
  }
};