/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../global_styling';
export var euiBadgeGroupStyles = function euiBadgeGroupStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiBadgeGroup: /*#__PURE__*/css("display:inline-flex;flex-wrap:wrap;", logicalCSS('max-width', '100%'), ".euiBadge+.euiBadge{", logicalCSS('margin-left', 0), ";};label:euiBadgeGroup;"),
    // Gutter sizes
    none: /*#__PURE__*/css(";label:none;"),
    s: /*#__PURE__*/css("gap:", euiTheme.size.s, ";;label:s;"),
    xs: /*#__PURE__*/css("gap:", euiTheme.size.xs, ";;label:xs;")
  };
};