import _typeof from "@babel/runtime/helpers/typeof";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "label", "color", "tooltipContent", "tooltipPosition", "anchorProps", "title", "iconType", "onClick", "onClickAriaLabel", "href", "rel", "target", "size", "alignment"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { getSecureRelForTarget, useEuiMemoizedStyles } from '../../../services';
import { EuiToolTip } from '../../tool_tip';
import { EuiIcon } from '../../icon';
import { euiBetaBadgeStyles } from './beta_badge.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['accent', 'subdued', 'hollow', 'warning'];
export var SIZES = ['s', 'm'];
export var ALIGNMENTS = ['baseline', 'middle'];

// `label` prop can be a `ReactNode` only if `title` or `tooltipContent` is provided

// Must be `type` instead of `interface`
// https://github.com/elastic/eui/issues/6085

export var EuiBetaBadge = function EuiBetaBadge(_ref) {
  var className = _ref.className,
    label = _ref.label,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'hollow' : _ref$color,
    tooltipContent = _ref.tooltipContent,
    _ref$tooltipPosition = _ref.tooltipPosition,
    tooltipPosition = _ref$tooltipPosition === void 0 ? 'top' : _ref$tooltipPosition,
    anchorProps = _ref.anchorProps,
    title = _ref.title,
    iconType = _ref.iconType,
    onClick = _ref.onClick,
    onClickAriaLabel = _ref.onClickAriaLabel,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$alignment = _ref.alignment,
    alignment = _ref$alignment === void 0 ? 'baseline' : _ref$alignment,
    rest = _objectWithoutProperties(_ref, _excluded);
  var singleLetter = !!(typeof label === 'string' && label.length === 1);
  var isCircular = iconType || singleLetter;
  var classes = classNames('euiBetaBadge', className);
  var styles = useEuiMemoizedStyles(euiBetaBadgeStyles);
  var cssStyles = [styles.euiBetaBadge, styles[color], styles[size], styles[alignment], isCircular ? styles.badgeSizes.circle[size] : styles.badgeSizes.default[size]];
  var icon;
  if (iconType) {
    icon = ___EmotionJSX(EuiIcon, {
      css: styles.euiBetaBadge__icon,
      className: "euiBetaBadge__icon",
      type: iconType,
      size: size === 'm' ? 'm' : 's',
      "aria-hidden": "true",
      color: "inherit" // forces the icon to inherit its parent color
    });
  }
  var Element = href ? 'a' : 'button';
  var relObj = {};
  if (href) {
    relObj.href = href;
    relObj.target = target;
    relObj.rel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
  }
  if (onClick) {
    relObj.onClick = onClick;
  }
  var content;
  if (onClick || href) {
    content = ___EmotionJSX(Element, _extends({
      "aria-label": onClickAriaLabel,
      css: cssStyles,
      className: classes,
      title: typeof label === 'string' ? label : title
    }, relObj, rest), icon || label);
    if (tooltipContent) {
      return ___EmotionJSX(EuiToolTip, {
        position: tooltipPosition,
        content: tooltipContent,
        title: title || label,
        anchorProps: anchorProps
      }, content);
    } else {
      return ___EmotionJSX("span", anchorProps, content);
    }
  } else {
    if (tooltipContent) {
      return ___EmotionJSX(EuiToolTip, {
        position: tooltipPosition,
        content: tooltipContent,
        title: title || label,
        anchorProps: anchorProps
      }, ___EmotionJSX("span", _extends({
        tabIndex: 0,
        css: cssStyles,
        className: classes
      }, rest), icon || label));
    } else {
      var spanTitle = title || label;
      if (spanTitle && typeof spanTitle !== 'string') {
        console.warn("Only string titles are permitted on badges that do not use tooltips. Found: ".concat(_typeof(spanTitle)));
      }
      return ___EmotionJSX("span", anchorProps, ___EmotionJSX("span", _extends({
        className: classes,
        title: spanTitle,
        css: cssStyles
      }, rest), icon || label));
    }
  }
};