import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import chroma from 'chroma-js';
import { isColorDark, tint } from '../../services';
import { euiButtonColor, euiButtonFillColor } from '../../themes/amsterdam/global_styling/mixins';
import { chromaValid, parseColor } from '../color_picker/utils';
export var euiBadgeColors = function euiBadgeColors(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  return {
    // Colors shared between buttons and badges
    primary: euiButtonFillColor(euiThemeContext, 'primary'),
    success: euiButtonFillColor(euiThemeContext, 'success'),
    warning: euiButtonFillColor(euiThemeContext, 'warning'),
    danger: euiButtonFillColor(euiThemeContext, 'danger'),
    accent: euiButtonFillColor(euiThemeContext, 'accent'),
    disabled: euiButtonColor(euiThemeContext, 'disabled'),
    // Colors unique to badges
    default: getBadgeColors(euiThemeContext, euiTheme.colors.lightShade),
    // Hollow has a border and is used for autocompleters and beta badges
    hollow: _objectSpread(_objectSpread({}, getBadgeColors(euiThemeContext, euiTheme.colors.emptyShade)), {}, {
      borderColor: colorMode === 'DARK' ? tint(euiTheme.border.color, 0.15) : euiTheme.border.color
    }),
    // Colors used by beta and notification badges
    subdued: getBadgeColors(euiThemeContext, tint(euiTheme.colors.lightShade, 0.3)),
    accentText: getBadgeColors(euiThemeContext, euiTheme.colors.accentText)
  };
};
export var getBadgeColors = function getBadgeColors(euiThemeContext, backgroundColor) {
  var color = getTextColor(euiThemeContext, backgroundColor);
  return {
    backgroundColor: backgroundColor,
    color: color
  };
};
export var getTextColor = function getTextColor(_ref, bgColor) {
  var euiTheme = _ref.euiTheme;
  var textColor = isColorDark.apply(void 0, _toConsumableArray(chroma(bgColor).rgb())) ? euiTheme.colors.ghost : euiTheme.colors.ink;
  return textColor;
};
export var getColorContrast = function getColorContrast(textColor, color) {
  return chroma.contrast(textColor, color);
};
export var getIsValidColor = function getIsValidColor(color) {
  return chromaValid(parseColor(color || '') || '');
};