/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, euiCanAnimate, euiFontSizeFromScale, euiNumberFormat, mathWithUnits } from '../../../global_styling';
import { euiBadgeColors } from '../color_utils';
export var euiNotificationBadgeStyles = function euiNotificationBadgeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var badgeColors = euiBadgeColors(euiThemeContext);
  return {
    euiNotificationBadge: /*#__PURE__*/css("flex-shrink:0;display:inline-block;vertical-align:middle;", logicalCSS('padding-horizontal', euiTheme.size.xs), " border-radius:", euiTheme.border.radius.small, ";cursor:default;font-size:", euiFontSizeFromScale('xs', euiTheme), ";font-weight:", euiTheme.font.weight.medium, ";", euiNumberFormat(euiThemeContext), " text-align:center;", euiCanAnimate, "{transition:all ", euiTheme.animation.fast, " ease-in;};label:euiNotificationBadge;"),
    // Sizes
    s: /*#__PURE__*/css("line-height:", euiTheme.size.base, ";", logicalCSS('height', euiTheme.size.base), " ", logicalCSS('min-width', euiTheme.size.base), ";;label:s;"),
    m: /*#__PURE__*/css("line-height:", mathWithUnits(euiTheme.size.xs, function (x) {
      return x + euiTheme.base;
    }), ";", logicalCSS('height', mathWithUnits(euiTheme.size.xs, function (x) {
      return x + euiTheme.base;
    })), " ", logicalCSS('min-width', euiTheme.size.l), ";;label:m;"),
    // Colors
    accent: /*#__PURE__*/css(badgeColors.accentText, ";label:accent;"),
    success: /*#__PURE__*/css(badgeColors.success, ";label:success;"),
    subdued: /*#__PURE__*/css(badgeColors.subdued, ";label:subdued;")
  };
};