import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiBasicTable } from './basic_table';
import { EuiButtonIcon } from '../button';
import { EuiHealth } from '../health';
import { EuiLink } from '../link';
import { EuiScreenReaderOnly } from '../accessibility';
import { formatDate } from '../../services';
import { faker } from '@faker-js/faker';
import { jsx as ___EmotionJSX } from "@emotion/react";
var users = [];
for (var i = 0; i < 20; i++) {
  users.push({
    id: i + 1,
    firstName: faker.person.firstName(),
    lastName: faker.person.lastName(),
    github: faker.internet.userName(),
    dateOfBirth: faker.date.past(),
    online: faker.datatype.boolean(),
    location: {
      city: faker.location.city(),
      country: faker.location.country()
    }
  });
}
var columns = [{
  field: 'firstName',
  name: 'First Name',
  sortable: true,
  truncateText: true,
  mobileOptions: {
    render: function render(user) {
      return ___EmotionJSX("span", null, user.firstName, " ", user.lastName);
    },
    header: false,
    truncateText: false,
    enlarge: true,
    width: '100%'
  }
}, {
  field: 'lastName',
  name: 'Last Name',
  truncateText: true,
  mobileOptions: {
    show: false
  }
}, {
  field: 'github',
  name: 'Github',
  render: function render(username) {
    return ___EmotionJSX(EuiLink, {
      href: "#",
      target: "_blank"
    }, username);
  }
}, {
  field: 'dateOfBirth',
  name: 'Date of Birth',
  dataType: 'date',
  render: function render(dateOfBirth) {
    return formatDate(dateOfBirth, 'dobLong');
  },
  sortable: true
}, {
  field: 'location',
  name: 'Location',
  truncateText: true,
  textOnly: true,
  render: function render(location) {
    return "".concat(location.city, ", ").concat(location.country);
  }
}, {
  field: 'online',
  name: 'Online',
  dataType: 'boolean',
  render: function render(online) {
    var color = online ? 'success' : 'danger';
    var label = online ? 'Online' : 'Offline';
    return ___EmotionJSX(EuiHealth, {
      color: color
    }, label);
  },
  sortable: true,
  mobileOptions: {
    show: false
  }
}];
describe('EuiTable', function () {
  var BasicTable = function BasicTable() {
    return ___EmotionJSX(EuiBasicTable, {
      tableCaption: "Demo of EuiBasicTable",
      columns: columns,
      items: users,
      "data-test-subj": "cy-basic-table"
    });
  };
  describe('Basic table', function () {
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.viewport(1024, 768); // medium breakpoint
        cy.realMount(___EmotionJSX(BasicTable, null));
        cy.get('[data-test-subj="cy-basic-table"]').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Mobile basic table', function () {
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.viewport(375, 667); // small breakpoint
        cy.realMount(___EmotionJSX(BasicTable, null));
        cy.get('[data-test-subj="cy-basic-table"]').should('exist');
        cy.checkAxe();
      });
    });
  });
  describe('Expandable rows', function () {
    var ExpandableRowTable = function ExpandableRowTable() {
      var _useState = useState({}),
        _useState2 = _slicedToArray(_useState, 2),
        itemIdToExpandedRowMap = _useState2[0],
        setItemIdToExpandedRowMap = _useState2[1];
      var toggleDetails = function toggleDetails(user) {
        var itemIdToExpandedRowMapValues = _objectSpread({}, itemIdToExpandedRowMap);
        if (itemIdToExpandedRowMapValues[user.id]) {
          delete itemIdToExpandedRowMapValues[user.id];
        } else {
          itemIdToExpandedRowMapValues[user.id] = ___EmotionJSX("div", null, ___EmotionJSX("p", null, "Location: ".concat(user.location.city)), ___EmotionJSX("p", null, "This person is online."));
        }
        setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
      };
      var columnsWithExpandingRowToggle = [].concat(columns, [{
        align: 'right',
        width: '40px',
        isExpander: true,
        name: ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, "Expand rows")),
        render: function render(user) {
          var itemIdToExpandedRowMapValues = _objectSpread({}, itemIdToExpandedRowMap);
          return ___EmotionJSX(EuiButtonIcon, {
            id: user.id.toString(),
            onClick: function onClick() {
              return toggleDetails(user);
            },
            "aria-label": itemIdToExpandedRowMapValues[user.id] ? 'Collapse' : 'Expand',
            iconType: itemIdToExpandedRowMapValues[user.id] ? 'arrowDown' : 'arrowRight'
          });
        }
      }]);
      return ___EmotionJSX(EuiBasicTable, {
        tableCaption: "Demo of EuiBasicTable with expanding rows",
        itemIdToExpandedRowMap: itemIdToExpandedRowMap,
        isExpandable: true,
        columns: columnsWithExpandingRowToggle,
        items: users,
        itemId: "id",
        "data-test-subj": "cy-expandable-row-table"
      });
    };
    beforeEach(function () {
      cy.viewport(1024, 768); // medium breakpoint
      cy.realMount(___EmotionJSX(ExpandableRowTable, null));
      cy.get('[data-test-subj="cy-expandable-row-table"]').should('exist');
    });
    describe('Automated accessibility check', function () {
      it('has zero violations on render', function () {
        cy.checkAxe();
      });
    });
    describe('Keyboard accessibility', function () {
      it('has zero violations after expanding a row', function () {
        cy.get('button#1').focus();
        cy.realPress('Enter');
        cy.get('tr.euiTableRow-isExpandedRow div.euiTableCellContent').should('exist');
        cy.checkAxe();
      });
    });
  });
});