import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "loading", "items", "itemId", "columns", "pagination", "sorting", "selection", "onChange", "error", "noItemsMessage", "compressed", "itemIdToExpandedRowMap", "responsiveBreakpoint", "rowProps", "cellProps", "tableCaption", "rowHeader", "tableLayout"],
  _excluded2 = ["align", "render", "dataType", "isExpander", "textOnly", "name", "field", "description", "sortable", "footer", "mobileOptions"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, Fragment } from 'react';
import classNames from 'classnames';
import { formatAuto, formatBoolean, formatDate, formatNumber, formatText, LEFT_ALIGNMENT, RIGHT_ALIGNMENT, SortDirection, RenderWithEuiTheme, OverrideCopiedTabularContent, tabularCopyMarkers } from '../../services';
import { isFunction } from '../../services/predicate';
import { get } from '../../services/objects';
import { EuiCheckbox } from '../form';
import { EuiComponentDefaultsContext } from '../provider/component_defaults';
import { euiTablePaginationDefaults } from '../table/table_pagination';
import { EuiTable, EuiTableBody, EuiTableFooter, EuiTableFooterCell, EuiTableHeader, EuiTableHeaderCell, EuiTableHeaderCellCheckbox, EuiTableHeaderMobile, EuiTableRow, EuiTableRowCell, EuiTableRowCellCheckbox, EuiTableSortMobile } from '../table';
import { euiTableCaptionStyles } from '../table/table.styles';
import { CollapsedItemActions } from './collapsed_item_actions';
import { ExpandedItemActions } from './expanded_item_actions';
import { PaginationBar } from './pagination_bar';
import { EuiIcon } from '../icon';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiI18n } from '../i18n';
import { EuiDelayRender } from '../delay_render';
import { htmlIdGenerator } from '../../services/accessibility';
import { euiBasicTableBodyLoading, safariLoadingWorkaround } from './basic_table.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var dataTypesProfiles = {
  auto: {
    align: LEFT_ALIGNMENT,
    render: function render(value) {
      return formatAuto(value);
    }
  },
  string: {
    align: LEFT_ALIGNMENT,
    render: function render(value) {
      return formatText(value);
    }
  },
  number: {
    align: RIGHT_ALIGNMENT,
    render: function render(value) {
      return formatNumber(value);
    }
  },
  boolean: {
    align: LEFT_ALIGNMENT,
    render: function render(value) {
      return formatBoolean(value);
    }
  },
  date: {
    align: LEFT_ALIGNMENT,
    render: function render(value) {
      return formatDate(value);
    }
  }
};
var DATA_TYPES = Object.keys(dataTypesProfiles);
export function getItemId(item, itemId) {
  if (itemId) {
    if (isFunction(itemId)) {
      return itemId(item);
    }
    // @ts-ignore never mind about the index signature
    return item[itemId];
  }
}
function getRowProps(item, rowProps) {
  if (rowProps) {
    if (isFunction(rowProps)) {
      return rowProps(item);
    }
    return rowProps;
  }
  return {};
}
function getCellProps(item, column, cellProps) {
  if (cellProps) {
    if (isFunction(cellProps)) {
      return cellProps(item, column);
    }
    return cellProps;
  }
  return {};
}
function getColumnFooter(column, _ref) {
  var items = _ref.items,
    pagination = _ref.pagination;
  var _ref2 = column,
    footer = _ref2.footer;
  if (footer) {
    if (isFunction(footer)) {
      return footer({
        items: items,
        pagination: pagination
      });
    }
    return footer;
  }
  return undefined;
}
function hasPagination(x) {
  return x.hasOwnProperty('pagination') && !!x.pagination;
}
export var EuiBasicTable = /*#__PURE__*/function (_Component) {
  function EuiBasicTable(props) {
    var _this;
    _classCallCheck(this, EuiBasicTable);
    _this = _callSuper(this, EuiBasicTable, [props]);
    _defineProperty(_this, "tableId", htmlIdGenerator('__table')());
    _defineProperty(_this, "selectAllIdGenerator", htmlIdGenerator('_selection_column-checkbox'));
    _defineProperty(_this, "renderSelectAll", function (isMobile) {
      var _this$props = _this.props,
        items = _this$props.items,
        selection = _this$props.selection;
      if (!selection) {
        return;
      }
      var selectableItems = items.filter(function (item) {
        return !selection.selectable || selection.selectable(item);
      });
      var checked = _this.state.selection && selectableItems.length > 0 && _this.state.selection.length === selectableItems.length;
      var indeterminate = !checked && _this.state.selection && selectableItems.length > 0 && _this.state.selection.length > 0;
      var disabled = selectableItems.length === 0;
      var onChange = function onChange(event) {
        if (event.target.checked && !indeterminate) {
          _this.changeSelection(selectableItems);
        } else {
          _this.changeSelection([]);
        }
      };
      return ___EmotionJSX(EuiI18n, {
        tokens: ['euiBasicTable.selectAllRows', 'euiBasicTable.deselectRows'],
        defaults: ['Select all rows', 'Deselect rows']
      }, function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          selectAllRows = _ref4[0],
          deselectRows = _ref4[1];
        return ___EmotionJSX(EuiCheckbox, {
          id: _this.selectAllIdGenerator(),
          checked: checked,
          indeterminate: indeterminate,
          disabled: disabled,
          onChange: onChange,
          "data-test-subj": "checkboxSelectAll",
          "aria-label": checked || indeterminate ? deselectRows : selectAllRows,
          title: checked || indeterminate ? deselectRows : selectAllRows,
          label: isMobile ? selectAllRows : null
        });
      });
    });
    _defineProperty(_this, "renderCopyChar", function (columnIndex) {
      var isLastColumn = columnIndex === _this.props.columns.length - 1;
      return isLastColumn ? tabularCopyMarkers.hiddenNewline : tabularCopyMarkers.hiddenTab;
    });
    _defineProperty(_this, "resolveColumnSortDirection", function (column) {
      var sorting = _this.props.sorting;
      var _ref5 = column,
        sortable = _ref5.sortable,
        field = _ref5.field,
        name = _ref5.name;
      if (!sorting || !sorting.sort || !sortable) {
        return;
      }
      if (sorting.sort.field === field || sorting.sort.field === name) {
        return sorting.sort.direction;
      }
    });
    _defineProperty(_this, "resolveColumnOnSort", function (column) {
      var sorting = _this.props.sorting;
      var _ref6 = column,
        sortable = _ref6.sortable,
        name = _ref6.name;
      if (!sorting || !sortable) {
        return;
      }
      if (!_this.props.onChange) {
        throw new Error("BasicTable is configured to be sortable on column [".concat(name, "] but\n          [onChange] is not configured. This callback must be implemented to handle the sort requests"));
      }
      return function () {
        return _this.onColumnSortChange(column);
      };
    });
    _this.state = {
      // used for checking if  initial selection is rendered
      initialSelectionRendered: false,
      selection: []
    };
    return _this;
  }
  _inherits(EuiBasicTable, _Component);
  return _createClass(EuiBasicTable, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.getInitialSelection();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.getInitialSelection();
    }
  }, {
    key: "pageSize",
    get: function get() {
      var _ref7, _this$props$paginatio, _this$props$paginatio2, _this$context$EuiTabl;
      return (_ref7 = (_this$props$paginatio = (_this$props$paginatio2 = this.props.pagination) === null || _this$props$paginatio2 === void 0 ? void 0 : _this$props$paginatio2.pageSize) !== null && _this$props$paginatio !== void 0 ? _this$props$paginatio : (_this$context$EuiTabl = this.context.EuiTablePagination) === null || _this$context$EuiTabl === void 0 ? void 0 : _this$context$EuiTabl.itemsPerPage) !== null && _ref7 !== void 0 ? _ref7 : euiTablePaginationDefaults.itemsPerPage;
    }
  }, {
    key: "isSelectionControlled",
    get: function get() {
      var _this$props$selection;
      return !!((_this$props$selection = this.props.selection) !== null && _this$props$selection !== void 0 && _this$props$selection.selected);
    }
  }, {
    key: "getInitialSelection",
    value: function getInitialSelection() {
      if (this.isSelectionControlled) return;
      if (this.props.selection && this.props.selection.initialSelected && !this.state.initialSelectionRendered && this.props.items.length > 0) {
        this.setState({
          selection: this.props.selection.initialSelected,
          initialSelectionRendered: true
        });
      }
    }
  }, {
    key: "buildCriteria",
    value: function buildCriteria(props) {
      var criteria = {};
      if (hasPagination(props)) {
        criteria.page = {
          index: props.pagination.pageIndex,
          size: this.pageSize
        };
      }
      if (props.sorting) {
        criteria.sort = props.sorting.sort;
      }
      return criteria;
    }
  }, {
    key: "changeSelection",
    value: function changeSelection(changedSelection) {
      var _selection$onSelectio;
      var selection = this.props.selection;
      if (!selection) return;
      (_selection$onSelectio = selection.onSelectionChange) === null || _selection$onSelectio === void 0 || _selection$onSelectio.call(selection, changedSelection);
      if (!this.isSelectionControlled) {
        this.setState({
          selection: changedSelection
        });
      }
    }
  }, {
    key: "clearSelection",
    value: function clearSelection() {
      this.changeSelection([]);
    }
  }, {
    key: "onPageSizeChange",
    value: function onPageSizeChange(size) {
      this.clearSelection();
      var currentCriteria = this.buildCriteria(this.props);
      var criteria = _objectSpread(_objectSpread({}, currentCriteria), {}, {
        page: {
          index: 0,
          // when page size changes, we take the user back to the first page
          size: size
        }
      });
      if (this.props.onChange) {
        this.props.onChange(criteria);
      }
    }
  }, {
    key: "onPageChange",
    value: function onPageChange(index) {
      this.clearSelection();
      var currentCriteria = this.buildCriteria(this.props);
      var criteria = _objectSpread(_objectSpread({}, currentCriteria), {}, {
        page: _objectSpread(_objectSpread({}, currentCriteria.page), {}, {
          index: index
        })
      });
      if (this.props.onChange) {
        this.props.onChange(criteria);
      }
    }
  }, {
    key: "onColumnSortChange",
    value: function onColumnSortChange(column) {
      this.clearSelection();
      var currentCriteria = this.buildCriteria(this.props);
      var direction = SortDirection.ASC;
      if (currentCriteria && currentCriteria.sort && (currentCriteria.sort.field === column.field || currentCriteria.sort.field === column.name)) {
        direction = SortDirection.reverse(currentCriteria.sort.direction);
      }
      var criteria = _objectSpread(_objectSpread({}, currentCriteria), {}, {
        // resetting the page if the criteria has one
        page: !currentCriteria.page ? undefined : {
          index: 0,
          size: currentCriteria.page.size
        },
        sort: {
          field: column.field || column.name,
          direction: direction
        }
      });
      if (this.props.onChange) {
        // @ts-ignore complex relationship between pagination's existence and criteria, the code logic ensures this is correctly maintained
        this.props.onChange(criteria);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        className = _this$props2.className,
        loading = _this$props2.loading,
        items = _this$props2.items,
        itemId = _this$props2.itemId,
        columns = _this$props2.columns,
        pagination = _this$props2.pagination,
        sorting = _this$props2.sorting,
        selection = _this$props2.selection,
        onChange = _this$props2.onChange,
        error = _this$props2.error,
        noItemsMessage = _this$props2.noItemsMessage,
        compressed = _this$props2.compressed,
        itemIdToExpandedRowMap = _this$props2.itemIdToExpandedRowMap,
        responsiveBreakpoint = _this$props2.responsiveBreakpoint,
        rowProps = _this$props2.rowProps,
        cellProps = _this$props2.cellProps,
        tableCaption = _this$props2.tableCaption,
        rowHeader = _this$props2.rowHeader,
        tableLayout = _this$props2.tableLayout,
        rest = _objectWithoutProperties(_this$props2, _excluded);
      var classes = classNames('euiBasicTable', {
        'euiBasicTable-loading': loading
      }, className);
      var table = this.renderTable();
      var paginationBar = this.renderPaginationBar();
      return ___EmotionJSX("div", _extends({
        className: classes
      }, rest), table, paginationBar);
    }
  }, {
    key: "renderTable",
    value: function renderTable() {
      var _this$props3 = this.props,
        compressed = _this$props3.compressed,
        responsiveBreakpoint = _this$props3.responsiveBreakpoint,
        tableLayout = _this$props3.tableLayout,
        loading = _this$props3.loading;
      return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiTableHeaderMobile, {
        responsiveBreakpoint: responsiveBreakpoint
      }, this.renderSelectAll(true), this.renderTableMobileSort()), ___EmotionJSX(OverrideCopiedTabularContent, null, ___EmotionJSX(EuiTable, {
        id: this.tableId,
        tableLayout: tableLayout,
        responsiveBreakpoint: responsiveBreakpoint,
        compressed: compressed,
        css: loading && safariLoadingWorkaround
      }, this.renderTableCaption(), this.renderTableHead(), this.renderTableBody(), this.renderTableFooter())));
    }
  }, {
    key: "renderTableMobileSort",
    value: function renderTableMobileSort() {
      var _this2 = this;
      var _this$props4 = this.props,
        columns = _this$props4.columns,
        sorting = _this$props4.sorting;
      var items = [];
      if (!sorting) {
        return null;
      }
      columns.forEach(function (column, index) {
        var _column;
        if (column.field && sorting.sort && !!sorting.enableAllColumns && column.sortable == null) {
          column = _objectSpread(_objectSpread({}, column), {}, {
            sortable: true
          });
        }
        if (!column.sortable || ((_column = column) === null || _column === void 0 || (_column = _column.mobileOptions) === null || _column === void 0 ? void 0 : _column.show) === false) {
          return;
        }
        var sortDirection = _this2.resolveColumnSortDirection(column);
        items.push({
          name: column.name,
          key: "_data_s_".concat(String(column.field), "_").concat(index),
          onSort: _this2.resolveColumnOnSort(column),
          isSorted: !!sortDirection,
          isSortAscending: sortDirection ? SortDirection.isAsc(sortDirection) : undefined
        });
      });
      return items.length ? ___EmotionJSX(EuiTableSortMobile, {
        items: items
      }) : null;
    }
  }, {
    key: "renderTableCaption",
    value: function renderTableCaption() {
      var _this$props5 = this.props,
        items = _this$props5.items,
        pagination = _this$props5.pagination,
        tableCaption = _this$props5.tableCaption;
      var itemCount = items.length;
      var totalItemCount = pagination ? pagination.totalItemCount : itemCount;
      var page = pagination ? pagination.pageIndex + 1 : 1;
      var pageCount = pagination ? Math.ceil(pagination.totalItemCount / this.pageSize) : 1;
      var captionElement;
      if (tableCaption) {
        if (pagination) {
          captionElement = ___EmotionJSX(EuiI18n, {
            token: "euiBasicTable.tableCaptionWithPagination",
            default: "{tableCaption}; Page {page} of {pageCount}.",
            values: {
              tableCaption: tableCaption,
              page: page,
              pageCount: pageCount
            }
          });
        } else {
          captionElement = tableCaption;
        }
      } else {
        if (pagination) {
          if (pagination.totalItemCount > 0) {
            captionElement = ___EmotionJSX(EuiI18n, {
              token: "euiBasicTable.tableAutoCaptionWithPagination",
              default: "This table contains {itemCount} rows out of {totalItemCount} rows; Page {page} of {pageCount}.",
              values: {
                totalItemCount: totalItemCount,
                itemCount: itemCount,
                page: page,
                pageCount: pageCount
              }
            });
          } else {
            captionElement = ___EmotionJSX(EuiI18n, {
              token: "euiBasicTable.tableSimpleAutoCaptionWithPagination",
              default: "This table contains {itemCount} rows; Page {page} of {pageCount}.",
              values: {
                itemCount: itemCount,
                page: page,
                pageCount: pageCount
              }
            });
          }
        } else {
          captionElement = ___EmotionJSX(EuiI18n, {
            token: "euiBasicTable.tableAutoCaptionWithoutPagination",
            default: "This table contains {itemCount} rows.",
            values: {
              itemCount: itemCount
            }
          });
        }
      }
      return ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("caption", {
        css: euiTableCaptionStyles,
        className: "euiTableCaption"
      }, tabularCopyMarkers.hiddenNoCopyBoundary, ___EmotionJSX(EuiDelayRender, null, captionElement), tabularCopyMarkers.hiddenNoCopyBoundary));
    }
  }, {
    key: "renderTableHead",
    value: function renderTableHead() {
      var _this3 = this;
      var _this$props6 = this.props,
        columns = _this$props6.columns,
        selection = _this$props6.selection;
      var headers = [];
      if (selection) {
        headers.push(___EmotionJSX(EuiTableHeaderCellCheckbox, {
          key: "_selection_column_h",
          append: this.renderCopyChar(-1)
        }, this.renderSelectAll(false)));
      }
      columns.forEach(function (column, index) {
        var _ref8 = column,
          field = _ref8.field,
          width = _ref8.width,
          name = _ref8.name,
          align = _ref8.align,
          dataType = _ref8.dataType,
          sortable = _ref8.sortable,
          mobileOptions = _ref8.mobileOptions,
          readOnly = _ref8.readOnly,
          description = _ref8.description;
        var columnAlign = align || _this3.getAlignForDataType(dataType);
        var sharedProps = {
          width: width,
          description: description,
          mobileOptions: mobileOptions,
          align: columnAlign,
          append: _this3.renderCopyChar(index)
        };

        // actions column
        if (column.actions) {
          headers.push(___EmotionJSX(EuiTableHeaderCell, _extends({}, sharedProps, {
            key: "_actions_h_".concat(index),
            align: "right"
          }), name));
          return;
        }

        // computed column
        if (!column.field) {
          var _sorting = {};
          // computed columns are only sortable if their `sortable` is a function
          if (_this3.props.sorting && typeof sortable === 'function') {
            var sortDirection = _this3.resolveColumnSortDirection(column);
            _sorting.isSorted = !!sortDirection;
            _sorting.isSortAscending = sortDirection ? SortDirection.isAsc(sortDirection) : undefined;
            _sorting.onSort = _this3.resolveColumnOnSort(column);
            _sorting.readOnly = _this3.props.sorting.readOnly || readOnly;
          }
          headers.push(___EmotionJSX(EuiTableHeaderCell, _extends({}, sharedProps, {
            key: "_computed_column_h_".concat(index),
            "data-test-subj": "tableHeaderCell_".concat(typeof name === 'string' ? name : '', "_").concat(index)
          }, _sorting), name));
          return;
        }

        // field data column
        var sorting = {};
        if (_this3.props.sorting) {
          if (_this3.props.sorting.sort && !!_this3.props.sorting.enableAllColumns && column.sortable == null) {
            column = _objectSpread(_objectSpread({}, column), {}, {
              sortable: true
            });
          }
          var _ref9 = column,
            _sortable = _ref9.sortable;
          if (_sortable) {
            var _sortDirection = _this3.resolveColumnSortDirection(column);
            sorting.isSorted = !!_sortDirection;
            sorting.isSortAscending = _sortDirection ? SortDirection.isAsc(_sortDirection) : undefined;
            sorting.onSort = _this3.resolveColumnOnSort(column);
            sorting.readOnly = _this3.props.sorting.readOnly || readOnly;
          }
        }
        headers.push(___EmotionJSX(EuiTableHeaderCell, _extends({}, sharedProps, {
          key: "_data_h_".concat(String(field), "_").concat(index),
          "data-test-subj": "tableHeaderCell_".concat(String(field), "_").concat(index)
        }, sorting), name));
      });
      return ___EmotionJSX(EuiTableHeader, null, headers);
    }
  }, {
    key: "renderTableFooter",
    value: function renderTableFooter() {
      var _this$props7 = this.props,
        items = _this$props7.items,
        columns = _this$props7.columns,
        pagination = _this$props7.pagination,
        selection = _this$props7.selection;
      var footers = [];
      var hasDefinedFooter = false;
      if (selection) {
        // Create an empty cell to compensate for additional selection column
        footers.push(___EmotionJSX(EuiTableFooterCell, {
          key: "_selection_column_f"
        }, undefined));
      }
      columns.forEach(function (column) {
        var footer = getColumnFooter(column, {
          items: items,
          pagination: pagination
        });
        var _ref10 = column,
          mobileOptions = _ref10.mobileOptions,
          field = _ref10.field,
          align = _ref10.align;
        if (mobileOptions !== null && mobileOptions !== void 0 && mobileOptions.only) {
          return; // exclude columns that only exist for mobile headers
        }
        if (footer) {
          footers.push(___EmotionJSX(EuiTableFooterCell, {
            key: "footer_".concat(String(field), "_").concat(footers.length - 1),
            align: align
          }, footer));
          hasDefinedFooter = true;
        } else {
          // Footer is undefined, so create an empty cell to preserve layout
          footers.push(___EmotionJSX(EuiTableFooterCell, {
            key: "footer_empty_".concat(footers.length - 1),
            align: align
          }, undefined));
        }
      });
      return footers.length && hasDefinedFooter ? ___EmotionJSX(EuiTableFooter, null, footers) : null;
    }
  }, {
    key: "renderTableBody",
    value: function renderTableBody() {
      var _this4 = this;
      var _this$props8 = this.props,
        error = _this$props8.error,
        loading = _this$props8.loading,
        items = _this$props8.items;
      var content;
      if (error) {
        content = this.renderErrorMessage(error);
      } else if (items.length === 0) {
        content = this.renderEmptyMessage();
      } else {
        content = items.map(function (item, index) {
          // if there's pagination the item's index must be adjusted to the where it is in the whole dataset
          var tableItemIndex = hasPagination(_this4.props) && _this4.pageSize > 0 ? _this4.props.pagination.pageIndex * _this4.pageSize + index : index;
          return _this4.renderItemRow(item, tableItemIndex, index);
        });
      }
      return ___EmotionJSX(RenderWithEuiTheme, null, function (theme) {
        return ___EmotionJSX(EuiTableBody, {
          css: loading && euiBasicTableBodyLoading(theme)
        }, content);
      });
    }
  }, {
    key: "renderErrorMessage",
    value: function renderErrorMessage(error) {
      var colSpan = this.props.columns.length + (this.props.selection ? 1 : 0);
      return ___EmotionJSX(EuiTableRow, null, ___EmotionJSX(EuiTableRowCell, {
        align: "center",
        colSpan: colSpan,
        mobileOptions: {
          width: '100%'
        }
      }, ___EmotionJSX(EuiIcon, {
        type: "minusInCircle",
        color: "danger"
      }), " ", error));
    }
  }, {
    key: "renderEmptyMessage",
    value: function renderEmptyMessage() {
      var _this$props9 = this.props,
        columns = _this$props9.columns,
        selection = _this$props9.selection,
        noItemsMessage = _this$props9.noItemsMessage;
      var colSpan = columns.length + (selection ? 1 : 0);
      return ___EmotionJSX(EuiTableRow, null, ___EmotionJSX(EuiTableRowCell, {
        align: "center",
        colSpan: colSpan,
        mobileOptions: {
          width: '100%'
        }
      }, noItemsMessage));
    }
  }, {
    key: "renderItemRow",
    value: function renderItemRow(item, rowIndex, displayedRowIndex) {
      var _this5 = this;
      var _this$props10 = this.props,
        columns = _this$props10.columns,
        selection = _this$props10.selection,
        rowHeader = _this$props10.rowHeader,
        itemIdToExpandedRowMap = _this$props10.itemIdToExpandedRowMap;
      var cells = [];
      var itemIdCallback = this.props.itemId;
      var itemId = getItemId(item, itemIdCallback) != null ? getItemId(item, itemIdCallback) : rowIndex;
      var selected = !selection ? false : this.state.selection && !!this.state.selection.find(function (selectedItem) {
        return getItemId(selectedItem, itemIdCallback) === itemId;
      });
      var rowSelectionDisabled = false;
      if (selection) {
        var _this$renderItemSelec = this.renderItemSelectionCell(itemId, item, selected, displayedRowIndex),
          _this$renderItemSelec2 = _slicedToArray(_this$renderItemSelec, 2),
          checkboxCell = _this$renderItemSelec2[0],
          isDisabled = _this$renderItemSelec2[1];
        cells.push(checkboxCell);
        rowSelectionDisabled = !!isDisabled;
      }
      var hasActions = false;
      columns.forEach(function (column, columnIndex) {
        var columnActions = column.actions;
        if (columnActions) {
          var hasCustomActions = columnActions.some(function (action) {
            return !!action.render;
          });
          cells.push(_this5.renderItemActionsCell(itemId, item, column, columnIndex, rowIndex, hasCustomActions));
          // A table theoretically could have both custom and default action items
          // If it has both, default action mobile row styles take precedence over custom
          hasActions = !hasActions && hasCustomActions ? 'custom' : true;
        } else if (column.field) {
          var fieldDataColumn = column;
          cells.push(_this5.renderItemFieldDataCell(itemId, item, column, columnIndex, fieldDataColumn.field === rowHeader));
        } else {
          cells.push(_this5.renderItemComputedCell(itemId, item, column, columnIndex));
        }
      });

      // Occupy full width of table, taking checkbox & mobile only columns into account.
      var expandedRowColSpan = selection ? columns.length + 1 : columns.length;
      var mobileOnlyCols = columns.reduce(function (num, column) {
        var _mobileOptions;
        return column !== null && column !== void 0 && (_mobileOptions = column.mobileOptions) !== null && _mobileOptions !== void 0 && _mobileOptions.only ? num + 1 : num + 0; // BWC only
      }, 0);
      expandedRowColSpan = expandedRowColSpan - mobileOnlyCols;

      // We'll use the ID to associate the expanded row with the original.
      var hasExpandedRow = itemIdToExpandedRowMap === null || itemIdToExpandedRowMap === void 0 ? void 0 : itemIdToExpandedRowMap.hasOwnProperty(itemId);
      var expandedRowId = hasExpandedRow ? "row_".concat(itemId, "_expansion") : undefined;
      var expandedRow = hasExpandedRow ? ___EmotionJSX(EuiTableRow, {
        id: expandedRowId,
        isExpandedRow: true,
        hasSelection: !!selection
      }, ___EmotionJSX(EuiTableRowCell, {
        colSpan: expandedRowColSpan,
        textOnly: false,
        append: tabularCopyMarkers.hiddenNewline
      }, itemIdToExpandedRowMap[itemId])) : undefined;
      var rowPropsCallback = this.props.rowProps;
      var rowProps = getRowProps(item, rowPropsCallback);
      var row = ___EmotionJSX(EuiTableRow, _extends({
        "aria-owns": expandedRowId,
        hasSelection: !!selection,
        isSelectable: !rowSelectionDisabled,
        isSelected: selected,
        hasActions: hasActions,
        isExpandable: hasExpandedRow
      }, rowProps), cells);
      return ___EmotionJSX(Fragment, {
        key: "row_".concat(itemId)
      }, row, expandedRow);
    }
  }, {
    key: "renderItemSelectionCell",
    value: function renderItemSelectionCell(itemId, item, selected, displayedRowIndex) {
      var _this6 = this;
      var selection = this.props.selection;
      var key = "_selection_column_".concat(itemId);
      var checked = selected;
      var disabled = selection.selectable && !selection.selectable(item);
      var title = selection.selectableMessage && selection.selectableMessage(!disabled, item);
      var onChange = function onChange(event) {
        if (event.target.checked) {
          _this6.changeSelection([].concat(_toConsumableArray(_this6.state.selection), [item]));
        } else {
          var itemIdCallback = _this6.props.itemId;
          _this6.changeSelection(_this6.state.selection.reduce(function (selection, selectedItem) {
            if (getItemId(selectedItem, itemIdCallback) !== itemId) {
              selection.push(selectedItem);
            }
            return selection;
          }, []));
        }
      };
      return [___EmotionJSX(EuiTableRowCellCheckbox, {
        key: key,
        append: this.renderCopyChar(-1)
      }, ___EmotionJSX(EuiI18n, {
        token: "euiBasicTable.selectThisRow",
        default: "Select row {index}",
        values: {
          index: displayedRowIndex + 1
        }
      }, function (selectThisRow) {
        return ___EmotionJSX(EuiCheckbox, {
          id: "".concat(_this6.tableId).concat(key, "-checkbox"),
          disabled: disabled,
          checked: checked,
          onChange: onChange,
          title: title || selectThisRow,
          "aria-label": title || selectThisRow,
          "data-test-subj": "checkboxSelectRow-".concat(itemId)
        });
      })), disabled];
    }
  }, {
    key: "renderItemActionsCell",
    value: function renderItemActionsCell(itemId, item, column, columnIndex, rowIndex, hasCustomActions) {
      // Disable all actions if any row(s) are selected
      var allDisabled = this.state.selection.length > 0;
      var actualActions = column.actions.filter(function (action) {
        return !action.available || action.available(item);
      });
      if (actualActions.length > 2) {
        if (allDisabled) {
          // If all actions are disabled, do not show any actions but the popover toggle
          actualActions = [];
        } else {
          // if any of the actions `isPrimary`, add them inline as well, but only the first 2,
          // which we'll force to only show on hover for desktop views
          var primaryActions = actualActions.filter(function (action) {
            return action.isPrimary;
          });
          actualActions = primaryActions.slice(0, 2).map(function (action) {
            return _objectSpread(_objectSpread({}, action), {}, {
              showOnHover: true
            });
          });
        }

        // if we have more than 1 action, we don't show them all in the cell, instead we
        // put them all in a popover tool. This effectively means we can only have a maximum
        // of one tool per row (it's either and normal action, or it's a popover that shows multiple actions)
        //
        // here we create a single custom action that triggers the popover with all the configured actions

        actualActions.push({
          name: 'All actions',
          render: function render(item) {
            return ___EmotionJSX(CollapsedItemActions, {
              className: "euiBasicTable__collapsedActions",
              actions: column.actions,
              actionsDisabled: allDisabled,
              itemId: itemId,
              item: item,
              displayedRowIndex: rowIndex
            });
          }
        });
      }
      var key = "record_actions_".concat(itemId, "_").concat(columnIndex);
      return ___EmotionJSX(EuiTableRowCell, {
        key: key,
        align: "right",
        textOnly: false,
        hasActions: hasCustomActions ? 'custom' : true,
        append: this.renderCopyChar(columnIndex)
      }, ___EmotionJSX(ExpandedItemActions, {
        actions: actualActions,
        actionsDisabled: allDisabled,
        itemId: itemId,
        item: item
      }));
    }
  }, {
    key: "renderItemFieldDataCell",
    value: function renderItemFieldDataCell(itemId, item, column, columnIndex, setScopeRow) {
      var field = column.field,
        render = column.render,
        dataType = column.dataType;
      var key = "_data_column_".concat(String(field), "_").concat(itemId, "_").concat(columnIndex);
      var contentRenderer = render || this.getRendererForDataType(dataType);
      var value = get(item, field);
      var content = contentRenderer(value, item);
      return this.renderItemCell(item, column, columnIndex, key, content, setScopeRow);
    }
  }, {
    key: "renderItemComputedCell",
    value: function renderItemComputedCell(itemId, item, column, columnIndex) {
      var render = column.render;
      var key = "_computed_column_".concat(itemId, "_").concat(columnIndex);
      var contentRenderer = render || this.getRendererForDataType();
      var content = contentRenderer(item);
      return this.renderItemCell(item, column, columnIndex, key, content, false);
    }
  }, {
    key: "renderItemCell",
    value: function renderItemCell(item, column, columnIndex, key, content, setScopeRow) {
      var _mobileOptions$render, _mobileOptions$header;
      var _ref11 = column,
        align = _ref11.align,
        render = _ref11.render,
        dataType = _ref11.dataType,
        isExpander = _ref11.isExpander,
        textOnly = _ref11.textOnly,
        name = _ref11.name,
        field = _ref11.field,
        description = _ref11.description,
        sortable = _ref11.sortable,
        footer = _ref11.footer,
        mobileOptions = _ref11.mobileOptions,
        rest = _objectWithoutProperties(_ref11, _excluded2);
      var columnAlign = align || this.getAlignForDataType(dataType);
      var cellPropsCallback = this.props.cellProps;
      var cellProps = getCellProps(item, column, cellPropsCallback);
      return ___EmotionJSX(EuiTableRowCell, _extends({
        key: key,
        align: columnAlign,
        isExpander: isExpander,
        textOnly: textOnly || !render,
        setScopeRow: setScopeRow,
        mobileOptions: _objectSpread(_objectSpread({}, mobileOptions), {}, {
          render: mobileOptions === null || mobileOptions === void 0 || (_mobileOptions$render = mobileOptions.render) === null || _mobileOptions$render === void 0 ? void 0 : _mobileOptions$render.call(mobileOptions, item),
          header: (_mobileOptions$header = mobileOptions === null || mobileOptions === void 0 ? void 0 : mobileOptions.header) !== null && _mobileOptions$header !== void 0 ? _mobileOptions$header : name
        })
      }, cellProps, rest, {
        append: this.renderCopyChar(columnIndex)
      }), content);
    }
  }, {
    key: "getRendererForDataType",
    value: function getRendererForDataType() {
      var dataType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'auto';
      var profile = dataTypesProfiles[dataType];
      if (!profile) {
        throw new Error("Unknown dataType [".concat(dataType, "]. The supported data types are [").concat(DATA_TYPES.join(', '), "]"));
      }
      return profile.render;
    }
  }, {
    key: "getAlignForDataType",
    value: function getAlignForDataType() {
      var dataType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'auto';
      var profile = dataTypesProfiles[dataType];
      if (!profile) {
        throw new Error("Unknown dataType [".concat(dataType, "]. The supported data types are [").concat(DATA_TYPES.join(', '), "]"));
      }
      return profile.align;
    }
  }, {
    key: "renderPaginationBar",
    value: function renderPaginationBar() {
      var _this7 = this;
      var _this$props11 = this.props,
        error = _this$props11.error,
        pagination = _this$props11.pagination,
        tableCaption = _this$props11.tableCaption,
        onChange = _this$props11.onChange;
      if (!error && pagination && pagination.totalItemCount > 0) {
        if (!onChange) {
          throw new Error("The Basic Table is configured with pagination but [onChange] is\n        not configured. This callback must be implemented to handle pagination changes");
        }
        return ___EmotionJSX(EuiI18n, {
          token: "euiBasicTable.tablePagination",
          default: "Pagination for table: {tableCaption}",
          values: {
            tableCaption: tableCaption
          }
        }, function (tablePagination) {
          return ___EmotionJSX(PaginationBar, {
            pagination: pagination,
            onPageSizeChange: _this7.onPageSizeChange.bind(_this7),
            onPageChange: _this7.onPageChange.bind(_this7),
            "aria-controls": _this7.tableId,
            "aria-label": tablePagination
          });
        });
      }
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (!nextProps.selection) {
        // next props doesn't have a selection, reset our state
        return {
          selection: []
        };
      }
      var controlledSelection = nextProps.selection.selected;
      var unfilteredSelection = controlledSelection !== null && controlledSelection !== void 0 ? controlledSelection : prevState.selection;

      // Ensure we're not including selections that aren't in the
      // current `items` array (affected by pagination)
      var itemId = nextProps.itemId,
        items = nextProps.items;
      var selection = unfilteredSelection.filter(function (selectedItem) {
        return items.findIndex(function (item) {
          return getItemId(item, itemId) === getItemId(selectedItem, itemId);
        }) !== -1;
      });

      // If some selected items were filtered out, update state and callback
      if (selection.length !== unfilteredSelection.length) {
        var _nextProps$selection$, _nextProps$selection;
        (_nextProps$selection$ = (_nextProps$selection = nextProps.selection).onSelectionChange) === null || _nextProps$selection$ === void 0 || _nextProps$selection$.call(_nextProps$selection, selection);
        return {
          selection: selection
        };
      }

      // Always update selection state from props if controlled
      if (controlledSelection) {
        return {
          selection: selection
        };
      }
      return null;
    }
  }]);
}(Component);
_defineProperty(EuiBasicTable, "contextType", EuiComponentDefaultsContext);
_defineProperty(EuiBasicTable, "defaultProps", {
  tableLayout: 'fixed',
  noItemsMessage: ___EmotionJSX(EuiI18n, {
    token: "euiBasicTable.noItemsMessage",
    default: "No items found"
  })
});