/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect } from 'react';
import { EuiSpacer } from '../spacer';
import { EuiTablePagination, useEuiTablePaginationDefaults } from '../table/table_pagination';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var PaginationBar = function PaginationBar(_ref) {
  var pagination = _ref.pagination,
    onPageSizeChange = _ref.onPageSizeChange,
    onPageChange = _ref.onPageChange,
    ariaControls = _ref['aria-controls'],
    ariaLabel = _ref['aria-label'];
  var defaults = useEuiTablePaginationDefaults();
  var pageIndex = pagination.pageIndex,
    totalItemCount = pagination.totalItemCount,
    _pagination$pageSize = pagination.pageSize,
    pageSize = _pagination$pageSize === void 0 ? defaults.itemsPerPage : _pagination$pageSize,
    _pagination$pageSizeO = pagination.pageSizeOptions,
    pageSizeOptions = _pagination$pageSizeO === void 0 ? defaults.itemsPerPageOptions : _pagination$pageSizeO,
    _pagination$showPerPa = pagination.showPerPageOptions,
    showPerPageOptions = _pagination$showPerPa === void 0 ? defaults.showPerPageOptions : _pagination$showPerPa;
  var pageCount = pageSize ? Math.ceil(totalItemCount / pageSize) : 1;
  useEffect(function () {
    if (pageCount < pageIndex + 1) {
      onPageChange === null || onPageChange === void 0 || onPageChange(pageCount - 1);
    }
  }, [pageCount, onPageChange, pageIndex]);
  return ___EmotionJSX("div", null, ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), ___EmotionJSX(EuiTablePagination, {
    activePage: pageIndex,
    showPerPageOptions: showPerPageOptions,
    itemsPerPage: pageSize,
    itemsPerPageOptions: pageSizeOptions,
    pageCount: pageCount,
    onChangeItemsPerPage: onPageSizeChange,
    onChangePage: onPageChange,
    "aria-controls": ariaControls,
    "aria-label": ariaLabel
  }));
};