import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "size", "color", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { logicalStyles } from '../../global_styling';
import { useEuiMemoizedStyles } from '../../services';
import { euiBeaconStyles } from './beacon.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['subdued', 'primary', 'success', 'accent', 'danger', 'warning'];
export var EuiBeacon = function EuiBeacon(_ref) {
  var className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 12 : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'success' : _ref$color,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiBeaconStyles);
  var classes = classNames('euiBeacon', className);
  var cssStyles = [styles.euiBeacon, styles[color]];
  var beaconStyle = useMemo(function () {
    return logicalStyles(_objectSpread(_objectSpread({}, style), {}, {
      height: size,
      width: size
    }));
  }, [style, size]);
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles,
    style: beaconStyle
  }, rest));
};