import _taggedTemplateLiteral from "@babel/runtime/helpers/taggedTemplateLiteral";
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css, keyframes } from '@emotion/react';
import { euiCanAnimate } from '../../global_styling';
import { shade } from '../../services';
import { euiShadowFlat } from '../../themes/amsterdam/global_styling/mixins';
var euiBottomBarAppear = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: translateY(100%);\n    opacity: 0;\n  }\n\n  100% {\n    transform: translateY(0%);\n    opacity: 1;\n  }\n"])));
export var euiBottomBarStyles = function euiBottomBarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    // `color` is inherited from the wrapping `EuiThemeProvider colorMode="dark"`
    euiBottomBar: /*#__PURE__*/css(euiShadowFlat(euiThemeContext), " background:", shade(euiTheme.colors.lightestShade, 0.5), ";", euiCanAnimate, "{animation:", euiBottomBarAppear, " ", euiTheme.animation.slow, " ", euiTheme.animation.resistance, ";};label:euiBottomBar;"),
    static: /*#__PURE__*/css(";label:static;"),
    // Default
    fixed: /*#__PURE__*/css("position:fixed;z-index:", Number(euiTheme.levels.header) - 2, ";;label:fixed;"),
    sticky: /*#__PURE__*/css("position:sticky;z-index:", Number(euiTheme.levels.header) - 2, ";;label:sticky;"),
    // Padding
    s: /*#__PURE__*/css("padding:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/css("padding:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/css("padding:", euiTheme.size.l, ";;label:l;"),
    none: ''
  };
};