import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["text", "truncate", "type", "href", "rel", "onClick", "popoverContent", "popoverProps", "className", "color", "isFirstBreadcrumb", "isLastBreadcrumb", "isOnlyBreadcrumb", "highlightLastBreadcrumb", "truncateLastBreadcrumb"],
  _excluded2 = ["css"],
  _excluded3 = ["popoverContent", "popoverProps", "color", "type", "title", "aria-current", "className", "isLastBreadcrumb", "breadcrumbCss", "truncationCss", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useCallback, forwardRef } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiInnerText } from '../inner_text';
import { EuiLink } from '../link';
import { EuiPopover } from '../popover';
import { EuiIcon } from '../icon';
import { useEuiI18n } from '../i18n';
import { euiBreadcrumbContentStyles, euiBreadcrumbPopoverStyles } from './_breadcrumb_content.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiBreadcrumbContent = function EuiBreadcrumbContent(_ref) {
  var text = _ref.text,
    truncate = _ref.truncate,
    type = _ref.type,
    href = _ref.href,
    rel = _ref.rel,
    onClick = _ref.onClick,
    popoverContent = _ref.popoverContent,
    popoverProps = _ref.popoverProps,
    className = _ref.className,
    color = _ref.color,
    isFirstBreadcrumb = _ref.isFirstBreadcrumb,
    isLastBreadcrumb = _ref.isLastBreadcrumb,
    isOnlyBreadcrumb = _ref.isOnlyBreadcrumb,
    highlightLastBreadcrumb = _ref.highlightLastBreadcrumb,
    truncateLastBreadcrumb = _ref.truncateLastBreadcrumb,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isApplication = type === 'application';
  var classes = classNames('euiBreadcrumb__content', className);
  var styles = useEuiMemoizedStyles(euiBreadcrumbContentStyles);
  var cssStyles = [styles.euiBreadcrumb__content, styles[type]];
  if (isApplication) {
    if (isOnlyBreadcrumb) {
      cssStyles.push(styles.applicationStyles.onlyChild);
    } else if (isFirstBreadcrumb) {
      cssStyles.push(styles.applicationStyles.firstChild);
    } else if (isLastBreadcrumb) {
      cssStyles.push(styles.applicationStyles.lastChild);
    }
  }
  var truncationStyles = [truncate && !truncateLastBreadcrumb && styles.isTruncated, truncateLastBreadcrumb && styles.isTruncatedLast];
  var isBreadcrumbWithPopover = !!popoverContent;
  var isInteractiveBreadcrumb = href || onClick;
  var linkColor = color || 'subdued';
  var ariaCurrent = highlightLastBreadcrumb ? 'page' : undefined;
  var interactionStyles = (isInteractiveBreadcrumb || isBreadcrumbWithPopover) && !isApplication && styles.isInteractive;
  return ___EmotionJSX(EuiInnerText, null, function (ref, innerText) {
    var title = innerText === '' ? undefined : innerText;
    var baseProps = {
      ref: ref,
      title: title,
      'aria-current': ariaCurrent,
      className: classes,
      css: [].concat(cssStyles, truncationStyles, [interactionStyles])
    };
    if (isBreadcrumbWithPopover) {
      var _ = baseProps.css,
        popoverButtonProps = _objectWithoutProperties(baseProps, _excluded2);
      return ___EmotionJSX(EuiBreadcrumbPopover, _extends({}, popoverButtonProps, {
        breadcrumbCss: [].concat(cssStyles, [interactionStyles]),
        truncationCss: truncationStyles,
        isLastBreadcrumb: isLastBreadcrumb,
        type: type,
        color: linkColor,
        popoverContent: popoverContent,
        popoverProps: popoverProps
      }, rest), text);
    } else if (isInteractiveBreadcrumb) {
      return ___EmotionJSX(EuiLink, _extends({}, baseProps, {
        color: linkColor,
        onClick: onClick,
        href: href,
        rel: rel
      }, rest), text);
    } else {
      return ___EmotionJSX("span", _extends({}, baseProps, rest), text);
    }
  });
};
var EuiBreadcrumbPopover = /*#__PURE__*/forwardRef(function (_ref2, ref) {
  var popoverContent = _ref2.popoverContent,
    popoverProps = _ref2.popoverProps,
    color = _ref2.color,
    type = _ref2.type,
    title = _ref2.title,
    ariaCurrent = _ref2['aria-current'],
    className = _ref2.className,
    isLastBreadcrumb = _ref2.isLastBreadcrumb,
    breadcrumbCss = _ref2.breadcrumbCss,
    truncationCss = _ref2.truncationCss,
    children = _ref2.children,
    rest = _objectWithoutProperties(_ref2, _excluded3);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var closePopover = useCallback(function () {
    return setIsPopoverOpen(false);
  }, []);
  var togglePopover = useCallback(function () {
    return setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var popoverAriaLabel = useEuiI18n(
  // This component was moved into another file for organization/dev readability,
  // but we're keeping the i18n token the same as before for consumer consistency
  // eslint-disable-next-line local/i18n
  'euiBreadcrumb.popoverAriaLabel', 'Clicking this button will toggle a popover dialog.');
  var styles = useEuiMemoizedStyles(euiBreadcrumbPopoverStyles);
  var wrapperStyles = [styles.popoverWrapper.euiBreadcrumb__popoverWrapper, !isLastBreadcrumb && styles.popoverWrapper[type]];
  var buttonStyles = [styles.euiBreadcrumb__popoverButton].concat(_toConsumableArray(breadcrumbCss));
  var truncationStyles = [styles.euiBreadcrumb__popoverTruncation].concat(_toConsumableArray(truncationCss));
  return ___EmotionJSX(EuiPopover, _extends({}, popoverProps, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    css: wrapperStyles,
    button: ___EmotionJSX(EuiLink, _extends({
      ref: ref,
      title: title,
      "aria-current": ariaCurrent,
      className: className,
      css: buttonStyles,
      color: color,
      onClick: togglePopover
    }, rest), ___EmotionJSX("span", {
      css: truncationStyles
    }, children), ___EmotionJSX(EuiIcon, {
      type: "arrowDown",
      size: "s",
      "aria-label": " - ".concat(popoverAriaLabel)
    }))
  }), typeof popoverContent === 'function' ? popoverContent(closePopover) : popoverContent);
});
EuiBreadcrumbPopover.displayName = 'EuiBreadcrumbPopover';