/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { tintOrShade } from '../../services/color';
import { euiFontSize, euiTextTruncate, euiFocusRing, logicalCSS, logicalBorderRadiusCSS, mathWithUnits } from '../../global_styling';
import { euiButtonColor } from '../../themes/amsterdam/global_styling/mixins/button';

/**
 * Styles cast to inner <a>, <button>, <span> elements
 */
export var euiBreadcrumbContentStyles = function euiBreadcrumbContentStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;

  // Reuse button colors for `type="application`" clickable breadcrumbs
  var applicationButtonColors = euiButtonColor(euiThemeContext, 'primary');

  // Create custom darker gray colors for non-clickable application breadcrumbs
  // The numbers/ratios are fairly specific here to pass WCAG AA contrast minimums
  var applicationTextColors = {
    backgroundColor: tintOrShade(euiTheme.colors.darkestShade, colorMode === 'DARK' ? 0.7 : 0.85, colorMode),
    color: tintOrShade(euiTheme.colors.darkestShade, 0.2, colorMode)
  };
  return {
    euiBreadcrumb__content: /*#__PURE__*/css("font-weight:", euiTheme.font.weight.regular, ";text-align:center;vertical-align:baseline;&:not(.euiLink){color:", euiTheme.colors.subduedText, ";};label:euiBreadcrumb__content;"),
    // Truncation styles
    isTruncated: /*#__PURE__*/css(euiTextTruncate(mathWithUnits(euiTheme.size.base, function (x) {
      return x * 10;
    })), ";;label:isTruncated;"),
    isTruncatedLast: /*#__PURE__*/css(euiTextTruncate('none'), ";;label:isTruncatedLast;"),
    isInteractive: /*#__PURE__*/css("&:not(:disabled){text-decoration:underline;&[class*='euiLink-subdued']{&:hover,&:focus{color:", euiTheme.colors.text, ";}}};label:isInteractive;"),
    // Types
    page: /*#__PURE__*/css("&:is(a):focus{", euiFocusRing(euiThemeContext, 'inset'), ";}&:is(button):focus{", euiFocusRing(euiThemeContext, 'center'), ";};label:page;"),
    application: /*#__PURE__*/css(euiFontSize(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.medium, ";background-color:", applicationTextColors.backgroundColor, ";clip-path:polygon(\n        0 0,\n        calc(100% - ", euiTheme.size.s, ") 0,\n        100% 50%,\n        calc(100% - ", euiTheme.size.s, ") 100%,\n        0 100%,\n        ", euiTheme.size.s, " 50%\n      );color:", applicationTextColors.color, ";line-height:", euiTheme.size.base, ";", logicalCSS('padding-vertical', euiTheme.size.xs), " ", logicalCSS('padding-horizontal', euiTheme.size.base), " &:is(a),&:is(button){background-color:", applicationButtonColors.backgroundColor, ";color:", applicationButtonColors.color, ";:focus{", euiFocusRing(euiThemeContext, 'inset'), " :focus-visible{border-radius:", euiTheme.border.radius.medium, ";clip-path:none;}}};label:application;"),
    applicationStyles: {
      onlyChild: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.medium, ";clip-path:none;", logicalCSS('padding-horizontal', euiTheme.size.m), ";;label:onlyChild;"),
      firstChild: /*#__PURE__*/css(logicalBorderRadiusCSS("".concat(euiTheme.border.radius.medium, " 0 0 ").concat(euiTheme.border.radius.medium), true), " clip-path:polygon(\n          0 0,\n          calc(100% - ", euiTheme.size.s, ") 0,\n          100% 50%,\n          calc(100% - ", euiTheme.size.s, ") 100%,\n          0 100%\n        );", logicalCSS('padding-left', euiTheme.size.m), ";;label:firstChild;"),
      lastChild: /*#__PURE__*/css(logicalBorderRadiusCSS("0 ".concat(euiTheme.border.radius.medium, " ").concat(euiTheme.border.radius.medium, " 0"), true), " clip-path:polygon(\n          0 0,\n          100% 0,\n          100% 100%,\n          0 100%,\n          ", euiTheme.size.s, " 50%\n        );", logicalCSS('padding-right', euiTheme.size.m), ";;label:lastChild;")
    }
  };
};
export var euiBreadcrumbPopoverStyles = function euiBreadcrumbPopoverStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiBreadcrumb__popoverButton: /*#__PURE__*/css("max-inline-size:100%;display:inline-flex;align-items:center;gap:", euiTheme.size.xs, ";;label:euiBreadcrumb__popoverButton;"),
    euiBreadcrumb__popoverTruncation: /*#__PURE__*/css(";label:euiBreadcrumb__popoverTruncation;"),
    popoverWrapper: {
      euiBreadcrumb__popoverWrapper: /*#__PURE__*/css(";label:euiBreadcrumb__popoverWrapper;"),
      page: /*#__PURE__*/css("max-inline-size:calc(\n          100% - ", mathWithUnits(euiTheme.size.base, function (x) {
        return x + 1;
      }), "\n        );;label:page;"),
      application: null
    }
  };
};