import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "type", "truncate"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useEuiI18n } from '../i18n';
import { EuiBreadcrumbContent } from './_breadcrumb_content';
import { euiBreadcrumbStyles } from './breadcrumb.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiBreadcrumb = function EuiBreadcrumb(_ref) {
  var children = _ref.children,
    className = _ref.className,
    type = _ref.type,
    truncate = _ref.truncate,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiBreadcrumb', className);
  var styles = useEuiMemoizedStyles(euiBreadcrumbStyles);
  var cssStyles = [styles.euiBreadcrumb, styles[type], truncate && styles.isTruncated];
  return ___EmotionJSX("li", _extends({
    className: classes,
    css: cssStyles,
    "data-test-subj": "euiBreadcrumb"
  }, rest), children);
};
export var EuiBreadcrumbCollapsed = function EuiBreadcrumbCollapsed(_ref2) {
  var children = _ref2.children,
    isFirstBreadcrumb = _ref2.isFirstBreadcrumb,
    type = _ref2.type;
  var styles = useEuiMemoizedStyles(euiBreadcrumbStyles);
  var cssStyles = [styles.isCollapsed];
  var ariaLabel = useEuiI18n('euiBreadcrumb.collapsedBadge.ariaLabel', 'See collapsed breadcrumbs');
  return ___EmotionJSX(EuiBreadcrumb, {
    css: cssStyles,
    type: type
  }, ___EmotionJSX(EuiBreadcrumbContent, {
    popoverContent: children,
    text: ___EmotionJSX("span", {
      "aria-label": ariaLabel
    }, "\u2026"),
    title: ariaLabel,
    truncate: false,
    isFirstBreadcrumb: isFirstBreadcrumb,
    type: type
  }));
};