import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "buttonRef", "size", "color", "fill"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { BUTTON_COLORS, useEuiButtonColorCSS, useEuiButtonFocusCSS } from '../../themes/amsterdam/global_styling/mixins/button';
import { EuiButtonDisplay, isButtonDisabled } from './button_display/_button_display';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = BUTTON_COLORS;
export var SIZES = ['s', 'm'];

// For some reason, Storybook doesn't parse `EuiButtonDisplayCommonProps` unless we include it here

/**
 * EuiButton is largely responsible for providing relevant props
 * and the logic for element-specific attributes
 */
export var EuiButton = function EuiButton(_ref) {
  var className = _ref.className,
    buttonRef = _ref.buttonRef,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    fill = _ref.fill,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isDisabled = isButtonDisabled({
    href: rest.href,
    isDisabled: rest.isDisabled || rest.disabled,
    isLoading: rest.isLoading
  });
  var buttonColorStyles = useEuiButtonColorCSS({
    display: fill ? 'fill' : 'base'
  })[isDisabled ? 'disabled' : color];
  var buttonFocusStyle = useEuiButtonFocusCSS();
  var classes = classNames('euiButton', className);
  var cssStyles = [buttonColorStyles, buttonFocusStyle];
  return ___EmotionJSX(EuiButtonDisplay, _extends({
    className: classes,
    css: cssStyles,
    ref: buttonRef,
    size: size
  }, rest));
};