import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["element", "type", "children", "iconType", "iconSide", "iconSize", "size", "isDisabled", "disabled", "isLoading", "isSelected", "fullWidth", "minWidth", "contentProps", "textProps", "href", "target", "rel", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef } from 'react';

// @ts-ignore module doesn't export `createElement`
import { createElement } from '@emotion/react';
import { getSecureRelForTarget, useEuiMemoizedStyles } from '../../../services';
import { euiButtonDisplayStyles } from './_button_display.styles';
import { EuiButtonDisplayContent } from './_button_display_content';
import { validateHref } from '../../../services/security/href_validator';
import { jsx as ___EmotionJSX } from "@emotion/react";
var SIZES = ['xs', 's', 'm'];

/**
 * Extends EuiButtonDisplayContentProps which provides
 * `iconType`, `iconSide`, and `textProps`
 */

export function isButtonDisabled(_ref) {
  var href = _ref.href,
    isDisabled = _ref.isDisabled,
    isLoading = _ref.isLoading;
  var isHrefValid = !href || validateHref(href);
  return isLoading || isDisabled || !isHrefValid;
}

/**
 * EuiButtonDisplay is an internal-only component used for displaying
 * any element as a button.
 */
export var EuiButtonDisplay = /*#__PURE__*/forwardRef(function (_ref2, ref) {
  var _ref2$element = _ref2.element,
    _element = _ref2$element === void 0 ? 'button' : _ref2$element,
    _ref2$type = _ref2.type,
    type = _ref2$type === void 0 ? 'button' : _ref2$type,
    children = _ref2.children,
    iconType = _ref2.iconType,
    _ref2$iconSide = _ref2.iconSide,
    iconSide = _ref2$iconSide === void 0 ? 'left' : _ref2$iconSide,
    iconSize = _ref2.iconSize,
    _ref2$size = _ref2.size,
    size = _ref2$size === void 0 ? 'm' : _ref2$size,
    isDisabled = _ref2.isDisabled,
    disabled = _ref2.disabled,
    isLoading = _ref2.isLoading,
    isSelected = _ref2.isSelected,
    fullWidth = _ref2.fullWidth,
    minWidth = _ref2.minWidth,
    contentProps = _ref2.contentProps,
    textProps = _ref2.textProps,
    href = _ref2.href,
    target = _ref2.target,
    rel = _ref2.rel,
    style = _ref2.style,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var buttonIsDisabled = isButtonDisabled({
    href: href,
    isDisabled: isDisabled || disabled,
    isLoading: isLoading
  });
  var styles = useEuiMemoizedStyles(euiButtonDisplayStyles);
  var cssStyles = [styles.euiButtonDisplay, styles[size], fullWidth && styles.fullWidth, minWidth == null && styles.defaultMinWidth, buttonIsDisabled && styles.isDisabled];
  var innerNode = ___EmotionJSX(EuiButtonDisplayContent, _extends({
    isLoading: isLoading,
    isDisabled: buttonIsDisabled,
    iconType: iconType,
    iconSide: iconSide,
    iconSize: iconSize,
    textProps: textProps
  }, contentProps), children);
  var element = buttonIsDisabled ? 'button' : href ? 'a' : _element;
  var elementProps = {};
  // Element-specific attributes
  if (element === 'button') {
    elementProps = _objectSpread(_objectSpread({}, elementProps), {}, {
      disabled: buttonIsDisabled,
      'aria-pressed': isSelected
    });
  }
  var relObj = {};
  if (href && !buttonIsDisabled) {
    relObj.href = href;
    relObj.rel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
  } else {
    relObj.type = type;
  }
  return createElement(element, _objectSpread(_objectSpread(_objectSpread({
    css: cssStyles,
    style: minWidth ? _objectSpread(_objectSpread({}, style), {}, {
      minInlineSize: minWidth
    }) : style,
    ref: ref
  }, elementProps), relObj), rest), innerNode);
});
EuiButtonDisplay.displayName = 'EuiButtonDisplay';