function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { euiFontSize, logicalCSS, logicalShorthandCSS, logicalTextAlignCSS } from '../../../global_styling';
import { euiButtonSizeMap } from '../../../themes/amsterdam/global_styling/mixins';
// Provides a solid reset and base for handling sizing layout
// Does not include any visual styles
export var euiButtonBaseCSS = function euiButtonBaseCSS() {
  return "\n    display: inline-block;\n    appearance: none;\n    cursor: pointer;\n    ".concat(logicalTextAlignCSS('center'), ";\n    white-space: nowrap;\n    ").concat(logicalCSS('max-width', '100%'), ";\n    vertical-align: middle;\n  ");
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;"
} : {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiButtonDisplayStyles = function euiButtonDisplayStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var sizes = euiButtonSizeMap(euiThemeContext);
  var _buttonSize = function _buttonSize(sizeKey) {
    var size = sizes[sizeKey];
    return /*#__PURE__*/css(logicalCSS('height', size.height), " line-height:", size.height, ";", euiFontSize(euiThemeContext, size.fontScale), " border-radius:", size.radius, ";");
  };
  return {
    // Base
    euiButtonDisplay: /*#__PURE__*/css(euiButtonBaseCSS(), " font-weight:", euiTheme.font.weight.medium, ";", logicalShorthandCSS('padding', "0 ".concat(euiTheme.size.m)), " &:hover:not(:disabled),&:focus{text-decoration:underline;};label:euiButtonDisplay;"),
    // States
    isDisabled: _ref,
    fullWidth: /*#__PURE__*/css("display:block;", logicalCSS('width', '100%'), ";;label:fullWidth;"),
    defaultMinWidth: /*#__PURE__*/css(logicalCSS('min-width', "".concat(euiTheme.base * 7, "px")), ";;label:defaultMinWidth;"),
    // Sizes
    xs: /*#__PURE__*/css(_buttonSize('xs'), ";label:xs;"),
    s: /*#__PURE__*/css(_buttonSize('s'), ";label:s;"),
    m: /*#__PURE__*/css(_buttonSize('m'), ";label:m;")
  };
};