import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "textProps", "isLoading", "isDisabled", "iconType", "iconSize", "iconSide"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiLoadingSpinner } from '../../loading';
import { EuiIcon } from '../../icon';
import { euiButtonDisplayContentStyles } from './_button_display_content.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ICON_SIZES = ['s', 'm'];
export var ICON_SIDES = ['left', 'right'];

/**
 * *INTERNAL ONLY*
 * This component is simply a helper component for reuse within other button components.
 */

export var EuiButtonDisplayContent = function EuiButtonDisplayContent(_ref) {
  var children = _ref.children,
    textProps = _ref.textProps,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    iconType = _ref.iconType,
    _ref$iconSize = _ref.iconSize,
    iconSize = _ref$iconSize === void 0 ? 'm' : _ref$iconSize,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'left' : _ref$iconSide,
    contentProps = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiButtonDisplayContentStyles);

  // Add an icon to the button if one exists.
  var icon = useMemo(function () {
    if (isLoading) {
      // When the button is disabled the text gets gray
      // and in some buttons the background gets a light gray
      // for better contrast we want to change the border of the spinner
      // to have the same color of the text. This way we ensure the borders
      // are always visible. The default spinner color could be very light.
      var loadingSpinnerColor = isDisabled ? {
        border: 'currentcolor'
      } : undefined;
      return ___EmotionJSX(EuiLoadingSpinner, {
        size: iconSize,
        color: loadingSpinnerColor
      });
    }
    if (iconType) {
      return ___EmotionJSX(EuiIcon, {
        type: iconType,
        size: iconSize,
        color: "inherit" // forces the icon to inherit its parent color
      });
    }
  }, [iconType, iconSize, isLoading, isDisabled]);
  var isText = typeof children === 'string';
  var doNotRenderTextWrapper = textProps === false;
  var renderTextWrapper = (isText || textProps) && !doNotRenderTextWrapper;
  return ___EmotionJSX("span", _extends({
    css: styles.euiButtonDisplayContent
  }, contentProps), iconSide === 'left' && icon, renderTextWrapper ? ___EmotionJSX("span", _extends({}, textProps, {
    className: classNames('eui-textTruncate', textProps === null || textProps === void 0 ? void 0 : textProps.className)
  }), children) : children, iconSide === 'right' && icon);
};