import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "iconType", "iconSide", "iconSize", "color", "size", "flush", "isDisabled", "disabled", "isLoading", "href", "target", "rel", "type", "buttonRef", "contentProps", "textProps", "isSelected"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, getSecureRelForTarget } from '../../../services';
import { EuiButtonDisplayContent } from '../button_display/_button_display_content';
import { useEuiButtonColorCSS } from '../../../themes/amsterdam/global_styling/mixins/button';
import { isButtonDisabled } from '../button_display/_button_display';
import { euiButtonEmptyStyles } from './button_empty.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['xs', 's', 'm'];
export var FLUSH_TYPES = ['left', 'right', 'both'];

/**
 * Extends EuiButtonContentProps which provides
 * `iconType`, `iconSide`, and `textProps`
 */

export var EuiButtonEmpty = function EuiButtonEmpty(_ref) {
  var children = _ref.children,
    className = _ref.className,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'left' : _ref$iconSide,
    _ref$iconSize = _ref.iconSize,
    iconSize = _ref$iconSize === void 0 ? 'm' : _ref$iconSize,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    flush = _ref.flush,
    _isDisabled = _ref.isDisabled,
    disabled = _ref.disabled,
    isLoading = _ref.isLoading,
    href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    buttonRef = _ref.buttonRef,
    contentProps = _ref.contentProps,
    textProps = _ref.textProps,
    isSelected = _ref.isSelected,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isDisabled = isButtonDisabled({
    isDisabled: _isDisabled || disabled,
    href: href,
    isLoading: isLoading
  });
  var buttonColorStyles = useEuiButtonColorCSS({
    display: 'empty'
  });
  var styles = useEuiMemoizedStyles(euiButtonEmptyStyles);
  var cssStyles = [styles.euiButtonEmpty, styles[size], buttonColorStyles[isDisabled ? 'disabled' : color], flush && styles.flush, flush && styles[flush], isDisabled && styles.isDisabled];
  var classes = classNames('euiButtonEmpty', className);
  var contentClassNames = classNames('euiButtonEmpty__content', contentProps === null || contentProps === void 0 ? void 0 : contentProps.className);
  var textClassNames = classNames('euiButtonEmpty__text', textProps && textProps.className);
  var innerNode = ___EmotionJSX(EuiButtonDisplayContent, _extends({
    isDisabled: isDisabled,
    isLoading: isLoading,
    iconType: iconType,
    iconSide: iconSide,
    iconSize: size === 'xs' ? 's' : iconSize,
    textProps: textProps === false ? false : _objectSpread(_objectSpread({}, textProps), {}, {
      className: textClassNames
    })
  }, _objectSpread(_objectSpread({}, contentProps), {}, {
    className: contentClassNames
  })), children);

  // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  // this is a button and piggyback off its disabled styles.
  if (href && !isDisabled) {
    var secureRel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
    return ___EmotionJSX("a", _extends({
      className: classes,
      css: cssStyles,
      href: href,
      target: target,
      rel: secureRel,
      ref: buttonRef
    }, rest), innerNode);
  }
  return ___EmotionJSX("button", _extends({
    disabled: isDisabled,
    className: classes,
    css: cssStyles,
    type: type,
    ref: buttonRef,
    "aria-pressed": isSelected
  }, rest), innerNode);
};