import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "id", "isDisabled", "isIconOnly", "isSelected", "label", "value", "size", "color", "toolTipContent", "toolTipProps"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import React from 'react';
import { useEuiMemoizedStyles } from '../../../services';
import { useEuiButtonColorCSS } from '../../../themes/amsterdam/global_styling/mixins/button';
import { useInnerText } from '../../inner_text';
import { EuiButtonDisplay } from '../button_display/_button_display';
import { euiButtonGroupButtonStyles, _compressedButtonFocusColors } from './button_group_button.styles';
import { EuiToolTip } from '../../../components/tool_tip';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiButtonGroupButton = function EuiButtonGroupButton(_ref) {
  var className = _ref.className,
    id = _ref.id,
    isDisabled = _ref.isDisabled,
    isIconOnly = _ref.isIconOnly,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    label = _ref.label,
    value = _ref.value,
    size = _ref.size,
    _ref$color = _ref.color,
    _color = _ref$color === void 0 ? 'primary' : _ref$color,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isCompressed = size === 'compressed';
  var color = isDisabled ? 'disabled' : _color;
  var display = isSelected ? 'fill' : isCompressed ? 'empty' : 'base';
  var hasToolTip = !!toolTipContent;
  var styles = useEuiMemoizedStyles(euiButtonGroupButtonStyles);
  var focusColorStyles = useEuiMemoizedStyles(_compressedButtonFocusColors);
  var buttonColorStyles = useEuiButtonColorCSS({
    display: display
  })[color];
  var cssStyles = [styles.euiButtonGroupButton, isIconOnly && styles.iconOnly, !isCompressed && (hasToolTip ? styles.uncompressed.hasToolTip : styles.uncompressed[size]), isCompressed ? styles.compressed : styles.uncompressed.uncompressed, isDisabled && isSelected ? styles.disabledAndSelected : buttonColorStyles, !isDisabled && isCompressed && focusColorStyles[color]];
  var tooltipWrapperStyles = [styles.tooltipWrapper, !isCompressed && styles.uncompressed[size]];
  var contentStyles = [styles.content.euiButtonGroupButton__content, isCompressed && styles.content.compressed];
  var textStyles = [isIconOnly ? styles.text.euiButtonGroupButton__iconOnly : styles.text.euiButtonGroupButton__text];
  var buttonClasses = classNames('euiButtonGroupButton', {
    'euiButtonGroupButton-isSelected': isSelected,
    'euiButtonGroupButton-isIconOnly': isIconOnly
  }, className);

  /**
   * Because the selected buttons also increase their text weight to 'bold',
   * we don't want the whole button size to shift when selected, so we determine
   * the base width of the button via the `euiTextShift()` method in SASS.
   */
  var _useInnerText = useInnerText(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    buttonTextRef = _useInnerText2[0],
    innerText = _useInnerText2[1];
  return ___EmotionJSX(EuiButtonGroupButtonWithToolTip, {
    toolTipContent: toolTipContent,
    toolTipProps: toolTipProps,
    wrapperCss: tooltipWrapperStyles,
    isSelected: isSelected
  }, ___EmotionJSX(EuiButtonDisplay, _extends({
    css: cssStyles,
    className: buttonClasses,
    isDisabled: isDisabled,
    size: size === 'compressed' ? 's' : size,
    contentProps: {
      css: contentStyles
    },
    textProps: {
      css: textStyles,
      ref: buttonTextRef,
      'data-text': innerText
    },
    title: innerText,
    "data-test-subj": id,
    isSelected: isSelected
  }, rest), label));
};
var EuiButtonGroupButtonWithToolTip = function EuiButtonGroupButtonWithToolTip(_ref2) {
  var _toolTipProps$anchorP, _toolTipProps$anchorP2;
  var toolTipContent = _ref2.toolTipContent,
    toolTipProps = _ref2.toolTipProps,
    wrapperCss = _ref2.wrapperCss,
    isSelected = _ref2.isSelected,
    children = _ref2.children;
  return toolTipContent ? ___EmotionJSX(EuiToolTip, _extends({
    content: toolTipContent,
    position: "top"
  }, toolTipProps, {
    anchorProps: _objectSpread(_objectSpread({}, toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorProps), {}, {
      className: classNames('euiButtonGroup__tooltipWrapper', {
        'euiButtonGroup__tooltipWrapper-isSelected': isSelected
      }, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP = toolTipProps.anchorProps) === null || _toolTipProps$anchorP === void 0 ? void 0 : _toolTipProps$anchorP.className),
      css: [wrapperCss, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP2 = toolTipProps.anchorProps) === null || _toolTipProps$anchorP2 === void 0 ? void 0 : _toolTipProps$anchorP2.css]
    })
  }), children) : children;
};