import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "iconType", "iconSize", "color", "isDisabled", "disabled", "href", "type", "display", "target", "rel", "size", "buttonRef", "isSelected", "isLoading"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { getSecureRelForTarget, useEuiMemoizedStyles } from '../../../services';
import { EuiIcon } from '../../icon';
import { EuiLoadingSpinner } from '../../loading';
import { useEuiButtonColorCSS, useEuiButtonFocusCSS } from '../../../themes/amsterdam/global_styling/mixins/button';
import { isButtonDisabled } from '../button_display/_button_display';
import { euiButtonIconStyles, _emptyHoverStyles } from './button_icon.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['xs', 's', 'm'];
export var DISPLAYS = ['base', 'empty', 'fill'];
export var EuiButtonIcon = function EuiButtonIcon(_ref) {
  var className = _ref.className,
    iconType = _ref.iconType,
    _ref$iconSize = _ref.iconSize,
    iconSize = _ref$iconSize === void 0 ? 'm' : _ref$iconSize,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    _isDisabled = _ref.isDisabled,
    disabled = _ref.disabled,
    href = _ref.href,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'empty' : _ref$display,
    target = _ref.target,
    rel = _ref.rel,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'xs' : _ref$size,
    buttonRef = _ref.buttonRef,
    isSelected = _ref.isSelected,
    isLoading = _ref.isLoading,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isDisabled = isButtonDisabled({
    isDisabled: _isDisabled || disabled,
    href: href,
    isLoading: isLoading
  });
  var ariaHidden = rest['aria-hidden'];
  var isAriaHidden = ariaHidden === 'true' || ariaHidden === true;
  if (!rest['aria-label'] && !rest['aria-labelledby'] && !isAriaHidden) {
    console.warn("EuiButtonIcon requires aria-label or aria-labelledby to be specified because icon-only\n      buttons are screen-reader-inaccessible without them.");
  }
  var buttonColorStyles = useEuiButtonColorCSS({
    display: display
  });
  var buttonFocusStyle = useEuiButtonFocusCSS();
  var emptyHoverStyles = useEuiMemoizedStyles(_emptyHoverStyles);
  var styles = useEuiMemoizedStyles(euiButtonIconStyles);
  var cssStyles = [styles.euiButtonIcon, styles[size], buttonColorStyles[isDisabled ? 'disabled' : color], buttonFocusStyle, display === 'empty' && !isDisabled && emptyHoverStyles[color], isDisabled && styles.isDisabled];
  var classes = classNames('euiButtonIcon', className);

  // Add an icon to the button if one exists.
  var buttonIcon;
  if (iconType && !isLoading) {
    buttonIcon = ___EmotionJSX(EuiIcon, {
      className: "euiButtonIcon__icon",
      type: iconType,
      size: iconSize,
      "aria-hidden": "true",
      color: "inherit" // forces the icon to inherit its parent color
    });
  }
  if (iconType && isLoading) {
    // `original` size doesn't exist in `EuiLoadingSpinner`
    // when the `iconSize` is `original` we don't pass any size to the `EuiLoadingSpinner`
    // so it gets the default size
    var loadingSize = iconSize === 'original' ? undefined : iconSize;

    // When the button is disabled the text gets gray
    // and in some buttons the background gets a light gray
    // for better contrast we want to change the border of the spinner
    // to have the same color of the text. This way we ensure the borders
    // are always visible. The default spinner color could be very light.
    var loadingSpinnerColor = isDisabled ? {
      border: 'currentcolor'
    } : undefined;
    buttonIcon = ___EmotionJSX(EuiLoadingSpinner, {
      size: loadingSize,
      color: loadingSpinnerColor
    });
  }

  // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
  // this is a button and piggyback off its disabled styles.
  if (href && !isDisabled) {
    var secureRel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
    return ___EmotionJSX("a", _extends({
      css: cssStyles,
      tabIndex: isAriaHidden ? -1 : undefined,
      className: classes,
      href: href,
      target: target,
      rel: secureRel,
      ref: buttonRef
    }, rest), buttonIcon);
  }
  var buttonType;
  return ___EmotionJSX("button", _extends({
    css: cssStyles,
    tabIndex: isAriaHidden ? -1 : undefined,
    disabled: isDisabled,
    className: classes,
    "aria-pressed": isSelected,
    type: type,
    ref: buttonRef
  }, rest), buttonIcon);
};