import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalSizeCSS } from '../../../global_styling';
import { BUTTON_COLORS, euiButtonEmptyColor, euiButtonSizeMap } from '../../../themes/amsterdam/global_styling/mixins/button';
import { euiButtonBaseCSS } from '../button_display/_button_display.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;"
} : {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiButtonIconStyles = function euiButtonIconStyles(euiThemeContext) {
  var sizes = euiButtonSizeMap(euiThemeContext);
  return {
    euiButtonIcon: /*#__PURE__*/css(euiButtonBaseCSS(), "display:inline-flex;align-items:center;justify-content:space-around;&>svg{pointer-events:none;};label:euiButtonIcon;"),
    isDisabled: _ref,
    // Sizes
    xs: /*#__PURE__*/css(logicalSizeCSS(sizes.xs.height), " border-radius:", sizes.xs.radius, ";;label:xs;"),
    s: /*#__PURE__*/css(logicalSizeCSS(sizes.s.height), " border-radius:", sizes.s.radius, ";;label:s;"),
    m: /*#__PURE__*/css(logicalSizeCSS(sizes.m.height), " border-radius:", sizes.m.radius, ";;label:m;")
  };
};
export var _emptyHoverStyles = function _emptyHoverStyles(euiThemeContext) {
  return BUTTON_COLORS.reduce(function (styles, color) {
    return _objectSpread(_objectSpread({}, styles), {}, _defineProperty({}, color, /*#__PURE__*/css("&:hover{background-color:", euiButtonEmptyColor(euiThemeContext, color).backgroundColor, ";}")));
  }, {});
};