import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["title", "color", "size", "iconType", "children", "className", "heading", "onDismiss"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiIcon } from '../icon';
import { EuiButtonIcon } from '../button';
import { EuiText } from '../text';
import { EuiPanel } from '../panel';
import { EuiSpacer } from '../spacer';
import { EuiTitle } from '../title';
import { EuiI18n } from '../i18n';
import { euiCallOutStyles, euiCallOutHeaderStyles } from './call_out.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['primary', 'success', 'warning', 'danger'];
export var HEADINGS = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p'];
export var EuiCallOut = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var title = _ref.title,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    iconType = _ref.iconType,
    children = _ref.children,
    className = _ref.className,
    _ref$heading = _ref.heading,
    heading = _ref$heading === void 0 ? 'p' : _ref$heading,
    onDismiss = _ref.onDismiss,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiCallOutStyles);
  var cssStyles = [styles.euiCallOut, onDismiss && styles.hasDismissButton.hasDimissButton, onDismiss && styles.hasDismissButton[size]];
  var classes = classNames('euiCallOut', _defineProperty({}, "euiCallOut--".concat(color), color), className);
  var dismissButton = useMemo(function () {
    if (!onDismiss) return;
    var cssStyles = [styles.dismissButton.euiCallOut__dismissButton, styles.dismissButton[size]];
    return ___EmotionJSX(EuiI18n, {
      token: "euiCallOut.dismissAriaLabel",
      default: "Dismiss this callout"
    }, function (dismissAriaLabel) {
      return ___EmotionJSX(EuiButtonIcon, {
        iconType: "cross",
        onClick: onDismiss,
        "aria-label": dismissAriaLabel,
        css: cssStyles,
        color: color,
        "data-test-subj": "euiDismissCalloutButton"
      });
    });
  }, [onDismiss, styles, color, size]);
  var headerStyles = useEuiMemoizedStyles(euiCallOutHeaderStyles);
  var header = useMemo(function () {
    if (!title) return;
    var H = heading;
    var cssStyles = [headerStyles.euiCallOutHeader, headerStyles[color]];
    return ___EmotionJSX(EuiTitle, {
      size: size === 's' ? 'xxs' : 'xs',
      css: cssStyles
    }, ___EmotionJSX(H, {
      className: "euiCallOutHeader__title"
    }, iconType && ___EmotionJSX(EuiIcon, {
      css: headerStyles.euiCallOut__icon,
      type: iconType,
      size: "m",
      "aria-hidden": "true",
      color: "inherit"
    }), title));
  }, [title, heading, iconType, size, color, headerStyles]);
  var optionalChildren = children && ___EmotionJSX(EuiText, {
    size: size === 's' ? 'xs' : 's',
    color: "default"
  }, children);
  return ___EmotionJSX(EuiPanel, _extends({
    borderRadius: "none",
    color: color,
    css: cssStyles,
    paddingSize: size === 's' ? 's' : 'm',
    className: classes,
    panelRef: ref,
    grow: false
  }, rest),
  // Note: the DOM position of the dismiss button matters to screen reader users.
  // We generally want them to have some context of _what_ they're dismissing,
  // instead of navigating to the dismiss button first before the callout content
  header && optionalChildren ? ___EmotionJSX(React.Fragment, null, header, dismissButton, ___EmotionJSX(EuiSpacer, {
    size: "s"
  }), optionalChildren) : ___EmotionJSX(React.Fragment, null, header || optionalChildren, dismissButton));
});
EuiCallOut.displayName = 'EuiCallOut';