import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiButtonEmpty } from '../button';
import { EuiCard } from './card';
import { EuiIcon } from '../icon';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Card = function Card() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    card1Selected = _useState2[0],
    setCard1 = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    card2Selected = _useState4[0],
    setCard2 = _useState4[1];
  var _useState5 = useState(false),
    _useState6 = _slicedToArray(_useState5, 2),
    card3Selected = _useState6[0],
    setCard3 = _useState6[1];
  var card1Clicked = function card1Clicked() {
    setCard1(!card1Selected);
  };
  var card2Clicked = function card2Clicked() {
    setCard2(!card2Selected);
  };
  var card3Clicked = function card3Clicked() {
    setCard3(!card3Selected);
  };
  var detailsClicked = function detailsClicked(e) {
    e.stopPropagation();
  };
  return ___EmotionJSX(EuiFlexGroup, {
    gutterSize: "l"
  }, ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiCard, {
    "data-test-subj": "cy-card-1",
    icon: ___EmotionJSX(EuiIcon, {
      size: "xxl",
      type: "logoSketch"
    }),
    title: "Sketch",
    description: "Example of a short card description.",
    footer: ___EmotionJSX(EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Sketch"
    }, "More details"),
    selectable: {
      onClick: card1Clicked,
      isSelected: card1Selected
    }
  })), ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiCard, {
    icon: ___EmotionJSX(EuiIcon, {
      size: "xxl",
      type: "logoGCP"
    }),
    title: "Google",
    description: "Example of a longer card description. See how the footers stay lined up.",
    footer: ___EmotionJSX(EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Google"
    }, "More details"),
    selectable: {
      onClick: card2Clicked,
      isSelected: card2Selected
    }
  })), ___EmotionJSX(EuiFlexItem, null, ___EmotionJSX(EuiCard, {
    icon: ___EmotionJSX(EuiIcon, {
      size: "xxl",
      type: "logoAerospike"
    }),
    title: "Not Adobe",
    description: "Example of a short card description.",
    footer: ___EmotionJSX(EuiButtonEmpty, {
      iconType: "iInCircle",
      size: "xs",
      onClick: detailsClicked,
      "aria-label": "See more details about Not Adobe"
    }, "More details"),
    selectable: {
      onClick: card3Clicked,
      isSelected: card3Selected
    }
  })));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount(___EmotionJSX(Card, null));
});
describe('EuiCard', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations after clicking buttons', function () {
      cy.get('button[aria-checked="false"]').each(function ($el) {
        cy.wrap($el).click();
      });
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.get('div[data-test-subj="cy-card-1"]').find('button.euiButtonEmpty').focus();
      cy.realPress('Tab');
      cy.realPress('{enter}');
      cy.get('div[data-test-subj="cy-card-1"]').find('button.euiButton').should('have.attr', 'aria-checked', 'true');
      cy.checkAxe();
    });
  });
});