import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "description", "isDisabled", "title", "titleElement", "titleSize", "icon", "image", "children", "footer", "onClick", "href", "rel", "target", "textAlign", "betaBadgeProps", "layout", "selectable", "display", "paddingSize"],
  _excluded2 = ["anchorProps"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { isValidElement } from 'react';
import classNames from 'classnames';
import { getSecureRelForTarget, useEuiTheme, cloneElementWithCss } from '../../services';
import { useGeneratedHtmlId } from '../../services/accessibility';
import { validateHref } from '../../services/security/href_validator';
import { EuiText } from '../text';
import { EuiTitle } from '../title';
import { EuiBetaBadge } from '../badge/beta_badge';
import { EuiPanel } from '../panel';
import { EuiSpacer } from '../spacer';
import { EuiCardSelect } from './card_select';
import { euiCardBetaBadgeStyles, euiCardStyles, euiCardTextStyles } from './card.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ALIGNMENTS = ['left', 'center', 'right'];

/**
 * Certain props are only allowed when the layout is vertical
 */

export var EuiCard = function EuiCard(_ref) {
  var className = _ref.className,
    description = _ref.description,
    _isDisabled = _ref.isDisabled,
    title = _ref.title,
    _ref$titleElement = _ref.titleElement,
    titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    icon = _ref.icon,
    image = _ref.image,
    children = _ref.children,
    footer = _ref.footer,
    onClick = _ref.onClick,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'center' : _ref$textAlign,
    betaBadgeProps = _ref.betaBadgeProps,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    selectable = _ref.selectable,
    display = _ref.display,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || validateHref(href);
  var isDisabled = _isDisabled || !isHrefValid;
  var isClickable = !isDisabled && (onClick || href || selectable && !selectable.isDisabled);
  var euiThemeContext = useEuiTheme();
  var styles = euiCardStyles(euiThemeContext, paddingSize);
  var cardStyles = [styles.card.euiCard,
  // Text alignment should always be left when horizontal
  styles.card.aligned[layout === 'horizontal' ? 'left' : textAlign], isDisabled && styles.card.disabled];
  var contentStyles = [styles.content.euiCard__content, styles.content.layout[layout]];
  var mainStyles = [styles.main.euiCard__main, styles.main.layout[layout]];
  var textStyles = euiCardTextStyles(euiThemeContext);
  var textCSS = [textStyles.euiCard__text,
  // Text alignment should always be left when horizontal
  textStyles.aligned[layout === 'horizontal' ? 'left' : textAlign], isClickable && textStyles.interactive, isDisabled && textStyles.disabled];

  /**
   * For a11y, we simulate the same click that's provided on the title when clicking the whole card
   * without having to make the whole card a button or anchor tag.
   * *Card Accessibility: The redundant click event https://inclusive-components.design/cards/*
   */
  var link = null;
  var outerOnClick = function outerOnClick(e) {
    if (link && link !== e.target && !link.contains(e.target)) {
      link.click();
    }
  };
  if (layout === 'horizontal') {
    if (image || footer || textAlign !== 'center') {
      throw new Error('EuiCard: `layout="horizontal"` cannot be used in conjunction with `image`, `footer`, or `textAlign`.');
    }
  }
  var classes = classNames('euiCard', className);
  var ariaId = useGeneratedHtmlId();
  var ariaDesc = description ? "".concat(ariaId, "Description") : '';

  /**
   * Top area containing image, icon or both
   */

  var imageNode;
  if (image && layout === 'vertical') {
    if ( /*#__PURE__*/isValidElement(image) || typeof image === 'string') {
      var imageStyles = [styles.image.euiCard__image, display === 'transparent' && styles.image.transparent];
      imageNode = ___EmotionJSX("div", {
        className: "euiCard__image",
        css: imageStyles
      }, /*#__PURE__*/isValidElement(image) ? image : ___EmotionJSX("img", {
        src: image,
        alt: ""
      }));
    } else {
      imageNode = null;
    }
  }
  var iconNode;
  if (icon) {
    var iconStyles = [styles.icon.euiCard__icon, styles.icon.layout[layout], imageNode && styles.icon.withImage];
    iconNode = cloneElementWithCss(icon, {
      className: classNames(icon.props.className, 'euiCard__icon'),
      css: iconStyles
    });
  }
  var optionalCardTop;
  if (imageNode || iconNode) {
    var topStyles = [styles.top.euiCard__top, styles.top.layout[layout], isDisabled && styles.top.disabled];
    optionalCardTop = ___EmotionJSX("div", {
      className: "euiCard__top",
      css: topStyles
    }, imageNode, iconNode);
  }

  /**
   * Optional EuiBetaBadge
   */

  var optionalBetaBadge;
  var optionalBetaBadgeID = '';
  var optionalBetaCSS;
  if (betaBadgeProps !== null && betaBadgeProps !== void 0 && betaBadgeProps.label) {
    var betaStyles = euiCardBetaBadgeStyles(euiThemeContext, paddingSize);
    optionalBetaCSS = betaStyles.hasBetaBadge;
    var anchorProps = betaBadgeProps.anchorProps,
      cleanedBetaBadgeProps = _objectWithoutProperties(betaBadgeProps, _excluded2);
    var anchorCSS = [betaStyles.euiCard__betaBadgeAnchor, anchorProps === null || anchorProps === void 0 ? void 0 : anchorProps.css];
    var badgeCSS = [betaStyles.euiCard__betaBadge, betaBadgeProps === null || betaBadgeProps === void 0 ? void 0 : betaBadgeProps.css];
    optionalBetaBadgeID = "".concat(ariaId, "BetaBadge");
    optionalBetaBadge = ___EmotionJSX(EuiBetaBadge, _extends({
      color: isDisabled && !betaBadgeProps.onClick && !betaBadgeProps.href ? 'subdued' : 'hollow'
    }, cleanedBetaBadgeProps, {
      css: badgeCSS,
      anchorProps: _objectSpread(_objectSpread({}, anchorProps), {}, {
        css: anchorCSS
      }),
      id: optionalBetaBadgeID
    }));

    // Increase padding size when there is a beta badge unless it's already determined
    // paddingSize = paddingSize || 'l';
  }

  /**
   * Optional selectable button
   */

  if (selectable && isDisabled && selectable.isDisabled === undefined) {
    selectable.isDisabled = isDisabled;
  }
  var optionalSelectButton;
  if (selectable) {
    optionalSelectButton = ___EmotionJSX(React.Fragment, null, paddingSize !== 'none' && ___EmotionJSX(EuiSpacer, {
      size: paddingSize || 'm'
    }), ___EmotionJSX(EuiCardSelect, _extends({
      "aria-describedby": "".concat(ariaId, "Title ").concat(ariaDesc)
    }, selectable, {
      buttonRef: function buttonRef(node) {
        link = node;
      }
    })));
  }
  var TitleElement = titleElement;

  /**
   * Wraps the title with the link (<a>) or button.
   * This makes the title element a11y friendly and gets described by its content if its interactable.
   */

  var theTitle;
  if (!isDisabled && href) {
    theTitle = ___EmotionJSX("a", {
      className: "euiCard__titleAnchor",
      css: textCSS,
      onClick: onClick,
      href: href,
      target: target,
      "aria-describedby": ariaDesc,
      rel: getSecureRelForTarget({
        href: href,
        target: target,
        rel: rel
      }),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else if (isDisabled || onClick) {
    theTitle = ___EmotionJSX("button", {
      className: "euiCard__titleButton",
      css: textCSS,
      onClick: onClick,
      disabled: isDisabled,
      "aria-describedby": "".concat(optionalBetaBadgeID, " ").concat(ariaDesc),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else {
    theTitle = ___EmotionJSX("span", {
      css: textCSS
    }, title);
  }

  /**
   * Children and/or Description content
   */
  var optionalChildren;
  if (children) {
    var childrenStyles = [styles.euiCard__children];
    optionalChildren = ___EmotionJSX("div", {
      css: childrenStyles
    }, children);
  }
  var optionalDescription;
  if (description) {
    var descriptionStyles = [styles.euiCard__description];
    optionalDescription = ___EmotionJSX(EuiText, {
      id: ariaDesc,
      size: "s",
      css: descriptionStyles
    }, ___EmotionJSX("p", null, description));
  }

  /**
   * Footer content
   */
  var optionalFooter;
  if (layout === 'vertical' && footer) {
    var footerStyles = [styles.euiCard__footer];
    optionalFooter = ___EmotionJSX("div", {
      css: footerStyles
    }, footer);
  }
  return ___EmotionJSX(EuiPanel, _extends({
    element: "div",
    className: classes,
    css: [].concat(cardStyles, [optionalBetaCSS]),
    onClick: isClickable ? outerOnClick : undefined,
    color: isDisabled ? 'subdued' : display,
    hasShadow: isDisabled || display ? false : true,
    hasBorder: display ? false : undefined,
    paddingSize: paddingSize
  }, rest), ___EmotionJSX("div", {
    className: "euiCard__main",
    css: mainStyles
  }, optionalCardTop, ___EmotionJSX("div", {
    className: "euiCard__content",
    css: contentStyles
  }, ___EmotionJSX(EuiTitle, {
    id: "".concat(ariaId, "Title"),
    className: "euiCard__title",
    size: titleSize
  }, ___EmotionJSX(TitleElement, null, theTitle)), optionalDescription, optionalChildren), optionalBetaBadge, optionalFooter), optionalSelectButton);
};