import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["isSelected", "isDisabled", "disabled", "color", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { EuiI18n } from '../../i18n';
import { EuiButton } from '../../button/button';
import { euiCardSelectStyles } from './card_select.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCardSelect = function EuiCardSelect(_ref) {
  var _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    isDisabled = _ref.isDisabled,
    disabled = _ref.disabled,
    color = _ref.color,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = euiCardSelectStyles();
  var baseCSS = [styles.euiCardSelect];
  var child = euiCardSelectableText(isSelected, isDisabled || disabled, children);
  return ___EmotionJSX(EuiButton, _extends({
    css: baseCSS,
    color: euiCardSelectableColor(color, isSelected),
    size: "m",
    isDisabled: isDisabled || disabled,
    iconType: isSelected ? 'check' : undefined,
    role: "switch",
    "aria-checked": isSelected,
    fullWidth: true
  }, rest), child);
};
function euiCardSelectableText(isSelected, isDisabled, children) {
  if (children) {
    return children;
  }
  var text;
  if (isSelected) {
    text = ___EmotionJSX(EuiI18n, {
      token: "euiCardSelect.selected",
      default: "Selected"
    });
  } else if (isDisabled) {
    text = ___EmotionJSX(EuiI18n, {
      token: "euiCardSelect.unavailable",
      default: "Unavailable"
    });
  } else {
    text = ___EmotionJSX(EuiI18n, {
      token: "euiCardSelect.select",
      default: "Select"
    });
  }
  return text;
}
export function euiCardSelectableColor(color, isSelected) {
  var calculatedColor;
  if (color) {
    calculatedColor = color;
  } else if (isSelected) {
    calculatedColor = 'success';
  } else {
    calculatedColor = 'text';
  }
  return calculatedColor;
}