/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiCanAnimate, euiPaddingSize, logicalCSS, logicals } from '../../../global_styling';
export var euiCheckableCardStyles = function euiCheckableCardStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var padding = euiPaddingSize(euiThemeContext, 'm');
  return {
    euiCheckableCard: /*#__PURE__*/css(euiCanAnimate, "{transition:border-color ", euiTheme.animation.normal, " ease-in;};label:euiCheckableCard;"),
    isChecked: /*#__PURE__*/css("border-color:", euiTheme.colors.primary, ";;label:isChecked;"),
    label: {
      euiCheckableCard__label: /*#__PURE__*/css("cursor:pointer;display:block;", logicals.width, ":calc(100% + (", padding, " * 2));padding:", padding, ";margin:-", padding, ";;label:euiCheckableCard__label;"),
      isDisabled: /*#__PURE__*/css("color:", euiTheme.colors.disabledText, ";cursor:not-allowed;;label:isDisabled;")
    },
    euiCheckableCard__children: /*#__PURE__*/css(logicalCSS('margin-top', euiTheme.size.base), ";;label:euiCheckableCard__children;")
  };
};