import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _typeof from "@babel/runtime/helpers/typeof";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["language", "transparentBackground", "paddingSize", "fontSize", "isCopyable", "copyAriaLabel", "whiteSpace", "children", "className", "overflowHeight", "isVirtualized", "lineNumbers"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useCombinedRefs, useEuiTheme, useEuiMemoizedStyles, tabularCopyMarkers } from '../../services';
import { DEFAULT_LANGUAGE, checkSupportedLanguage, getHtmlContent, highlightByLine } from './utils';
import { useOverflow } from './code_block_overflow';
import { useCopy } from './code_block_copy';
import { useFullScreen, EuiCodeBlockFullScreenWrapper } from './code_block_full_screen';
import { EuiCodeBlockControls } from './code_block_controls';
import { EuiCodeBlockVirtualized } from './code_block_virtualized';
import { euiCodeBlockStyles, euiCodeBlockPreStyles, euiCodeBlockCodeStyles } from './code_block.styles';
import { EuiScreenReaderOnly } from '../accessibility';
import { useEuiI18n } from '../i18n';

// Based on observed line height for non-virtualized code blocks
import { jsx as ___EmotionJSX } from "@emotion/react";
var fontSizeToRowHeightMap = {
  s: 18,
  m: 21,
  l: 24
};
export var FONT_SIZES = ['s', 'm', 'l'];
export var PADDING_SIZES = ['none', 's', 'm', 'l'];

// This exclusive union enforces specific props based on isVirtualized

export var EuiCodeBlock = function EuiCodeBlock(_ref) {
  var _ref$language = _ref.language,
    _language = _ref$language === void 0 ? DEFAULT_LANGUAGE : _ref$language,
    _ref$transparentBackg = _ref.transparentBackground,
    transparentBackground = _ref$transparentBackg === void 0 ? false : _ref$transparentBackg,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$fontSize = _ref.fontSize,
    fontSize = _ref$fontSize === void 0 ? 's' : _ref$fontSize,
    _ref$isCopyable = _ref.isCopyable,
    isCopyable = _ref$isCopyable === void 0 ? false : _ref$isCopyable,
    copyAriaLabel = _ref.copyAriaLabel,
    _ref$whiteSpace = _ref.whiteSpace,
    whiteSpace = _ref$whiteSpace === void 0 ? 'pre-wrap' : _ref$whiteSpace,
    children = _ref.children,
    className = _ref.className,
    overflowHeight = _ref.overflowHeight,
    _isVirtualized = _ref.isVirtualized,
    _ref$lineNumbers = _ref.lineNumbers,
    lineNumbers = _ref$lineNumbers === void 0 ? false : _ref$lineNumbers,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var language = useMemo(function () {
    return checkSupportedLanguage(_language);
  }, [_language]);
  var lineNumbersConfig = useMemo(function () {
    var config = _typeof(lineNumbers) === 'object' ? lineNumbers : {};
    return lineNumbers ? _objectSpread({
      start: 1,
      show: true
    }, config) : {
      start: 1,
      show: false
    };
  }, [lineNumbers]);

  // Used by `FixedSizeList` when `isVirtualized=true` or `children` is parsable
  var data = useMemo(function () {
    if (typeof children !== 'string') {
      return [];
    }
    return highlightByLine(children, language, lineNumbersConfig, euiTheme);
  }, [children, language, lineNumbersConfig, euiTheme]);

  // Used by `pre` when `isVirtualized=false` or `children` is not parsable
  var content = useMemo(function () {
    return getHtmlContent(data, children);
  }, [data, children]);
  var isVirtualized = useMemo(function () {
    return !!(_isVirtualized && Array.isArray(data));
  }, [_isVirtualized, data]);
  var _useCopy = useCopy({
      copyAriaLabel: copyAriaLabel,
      isCopyable: isCopyable,
      isVirtualized: isVirtualized,
      children: children
    }),
    innerTextRef = _useCopy.innerTextRef,
    copyButton = _useCopy.copyButton;
  var _useOverflow = useOverflow({
      overflowHeight: overflowHeight
    }),
    setWrapperRef = _useOverflow.setWrapperRef,
    tabIndex = _useOverflow.tabIndex,
    overflowHeightStyles = _useOverflow.overflowHeightStyles;
  var combinedRef = useCombinedRefs([innerTextRef, setWrapperRef]);
  var _useFullScreen = useFullScreen({
      overflowHeight: overflowHeight
    }),
    fullScreenButton = _useFullScreen.fullScreenButton,
    isFullScreen = _useFullScreen.isFullScreen,
    onKeyDown = _useFullScreen.onKeyDown;
  var hasControls = !!(copyButton || fullScreenButton);
  var hasBothControls = !!(copyButton && fullScreenButton);
  var styles = useEuiMemoizedStyles(euiCodeBlockStyles);
  var cssStyles = [styles.euiCodeBlock, styles[fontSize], transparentBackground && styles.transparentBackground, hasControls && (hasBothControls ? styles.hasBothControls[paddingSize] : styles.hasControls[paddingSize])];
  var preStyles = useEuiMemoizedStyles(euiCodeBlockPreStyles);
  var _useMemo = useMemo(function () {
      var isWhiteSpacePre = whiteSpace === 'pre' || isVirtualized;
      var cssStyles = [preStyles.euiCodeBlock__pre, isWhiteSpacePre ? preStyles.whiteSpace.pre.pre : preStyles.whiteSpace.preWrap.preWrap];
      var preProps = {
        className: 'euiCodeBlock__pre',
        css: [].concat(cssStyles, [preStyles.padding[paddingSize], hasControls && (isWhiteSpacePre ? preStyles.whiteSpace.pre.controlsOffset[paddingSize] : preStyles.whiteSpace.preWrap.controlsOffset[paddingSize])]),
        tabIndex: isVirtualized ? 0 : tabIndex
      };
      var preFullscreenProps = {
        className: 'euiCodeBlock__pre',
        css: [].concat(cssStyles, [
        // Force fullscreen to use xl padding
        preStyles.padding.xl, hasControls && (isWhiteSpacePre ? preStyles.whiteSpace.pre.controlsOffset.xl : preStyles.whiteSpace.preWrap.controlsOffset.xl)]),
        tabIndex: 0
      };
      return [preProps, preFullscreenProps];
    }, [preStyles, whiteSpace, isVirtualized, hasControls, paddingSize, tabIndex]),
    _useMemo2 = _slicedToArray(_useMemo, 2),
    preProps = _useMemo2[0],
    preFullscreenProps = _useMemo2[1];
  var codeStyles = useEuiMemoizedStyles(euiCodeBlockCodeStyles);
  var codeProps = useMemo(function () {
    var cssStyles = [codeStyles.euiCodeBlock__code, isVirtualized && codeStyles.isVirtualized];
    return _objectSpread({
      className: 'euiCodeBlock__code',
      css: cssStyles,
      'data-code-language': language
    }, rest);
  }, [codeStyles, language, isVirtualized, rest]);
  var codeBlockLabel = useEuiI18n('euiCodeBlock.label', '{language} code block:', {
    language: language
  });
  // pre tags don't accept aria-label without an
  // appropriate role, we add a SR only text instead
  var codeBlockLabelElement = ___EmotionJSX(React.Fragment, null, tabularCopyMarkers.hiddenNoCopyBoundary, ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("div", null, codeBlockLabel)), tabularCopyMarkers.hiddenNoCopyBoundary);
  return ___EmotionJSX("div", {
    css: cssStyles,
    className: classNames('euiCodeBlock', className),
    style: overflowHeightStyles
  }, isVirtualized ? ___EmotionJSX(EuiCodeBlockVirtualized, {
    data: data,
    rowHeight: fontSizeToRowHeightMap[fontSize],
    overflowHeight: overflowHeight,
    preProps: preProps,
    codeProps: codeProps
  }) : ___EmotionJSX("pre", _extends({}, preProps, {
    ref: combinedRef,
    style: overflowHeightStyles
  }), codeBlockLabelElement, ___EmotionJSX("code", codeProps, content)), ___EmotionJSX(EuiCodeBlockControls, {
    controls: [fullScreenButton, copyButton],
    paddingSize: paddingSize
  }), isFullScreen && ___EmotionJSX(EuiCodeBlockFullScreenWrapper, {
    onClose: onKeyDown
  }, isVirtualized ? ___EmotionJSX(EuiCodeBlockVirtualized, {
    data: data,
    rowHeight: fontSizeToRowHeightMap.l,
    preProps: preFullscreenProps,
    codeProps: codeProps
  }) : ___EmotionJSX("pre", preFullscreenProps, codeBlockLabelElement, ___EmotionJSX("code", codeProps, content)), ___EmotionJSX(EuiCodeBlockControls, {
    controls: [fullScreenButton, copyButton],
    paddingSize: "l"
  })));
};