import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["lineNumber", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState } from 'react';
import { useEuiTheme, useEuiMemoizedStyles } from '../../services';
import { useEuiButtonFocusCSS } from '../../themes/amsterdam/global_styling/mixins/button';
import { useEuiI18n } from '../i18n';
import { EuiPopover } from '../popover';
import { EuiIcon } from '../icon';
import { euiCodeBlockAnnotationsStyles } from './code_block_annotations.style';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCodeBlockAnnotation = function EuiCodeBlockAnnotation(_ref) {
  var lineNumber = _ref.lineNumber,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var ariaLabel = useEuiI18n('euiCodeBlockAnnotations.ariaLabel', 'Click to view a code annotation for line {lineNumber}', {
    lineNumber: lineNumber
  });
  var styles = useEuiMemoizedStyles(euiCodeBlockAnnotationsStyles);
  var buttonIconFocusStyle = useEuiButtonFocusCSS();
  var cssButtonIconStyles = [styles.euiCodeBlockAnnotation__buttonIcon, buttonIconFocusStyle];
  var _useEuiTheme = useEuiTheme(),
    euiTheme = _useEuiTheme.euiTheme,
    colorMode = _useEuiTheme.colorMode;
  var isDarkMode = colorMode === 'DARK';
  var iconColor = isDarkMode ? euiTheme.colors.ink : 'ghost';
  return ___EmotionJSX(EuiPopover, _extends({
    css: styles.euiCodeBlockAnnotation
  }, rest, {
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    button: ___EmotionJSX("button", {
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      },
      "aria-label": ariaLabel,
      css: cssButtonIconStyles,
      "data-test-subj": "euiCodeBlockAnnotationIcon"
    }, ___EmotionJSX(EuiIcon, {
      type: AnnotationInfoIcon,
      size: "s",
      color: iconColor
    })),
    zIndex: Number(euiTheme.levels.mask) + 1 // Ensure fullscreen annotation popovers sit above the mask
    ,
    anchorPosition: "downLeft",
    panelProps: {
      'data-test-subj': 'euiCodeBlockAnnotationPopover'
    }
  }), children);
};
var AnnotationInfoIcon = function AnnotationInfoIcon(props) {
  return ___EmotionJSX("svg", _extends({
    width: 11,
    height: 11,
    viewBox: "0 0 16 16",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), ___EmotionJSX("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M7.139 14l-.052-6.007H5V6.28h4.111l.052 6.007h1.915V14h-3.94zM6.712 3.38c0-.396.118-.725.354-.987S7.639 2 8.077 2c.438 0 .777.131 1.016.393.24.262.359.591.359.987 0 .39-.12.714-.359.972s-.578.388-1.016.388c-.438 0-.775-.13-1.011-.388-.236-.258-.354-.582-.354-.972z"
  }));
};