/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalSizeCSS, mathWithUnits } from '../../global_styling';
export var euiCodeBlockAnnotationsStyles = function euiCodeBlockAnnotationsStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  var buttonIconSize = mathWithUnits(euiTheme.size.base, function (x) {
    return x - 1.5;
  });
  return {
    euiCodeBlockAnnotation: /*#__PURE__*/css("position:absolute;", logicalCSS('right', 0), " ", logicalCSS('top', '50%'), " transform:translate(50%, -50%);line-height:1;;label:euiCodeBlockAnnotation;"),
    euiCodeBlockAnnotation__buttonIcon: /*#__PURE__*/css(logicalSizeCSS(buttonIconSize), " display:flex;align-items:center;justify-content:center;background-color:", euiTheme.colors.primary, ";border-radius:50%;;label:euiCodeBlockAnnotation__buttonIcon;")
  };
};