/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Fragment } from 'react';
import { useEuiMemoizedStyles } from '../../services';
import { euiCodeBlockControlsStyles } from './code_block_controls.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCodeBlockControls = function EuiCodeBlockControls(_ref) {
  var paddingSize = _ref.paddingSize,
    controls = _ref.controls;
  var styles = useEuiMemoizedStyles(euiCodeBlockControlsStyles);
  var cssStyles = [styles.euiCodeBlock__controls, styles.offset[paddingSize]];
  var hasControls = controls.some(function (control) {
    return !!control;
  });
  return hasControls ? ___EmotionJSX("div", {
    className: "euiCodeBlock__controls",
    css: cssStyles
  }, controls.map(function (control, i) {
    return ___EmotionJSX(Fragment, {
      key: i
    }, control);
  })) : null;
};