import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import { noCopyBoundsRegex } from '../../services';
import { useInnerText } from '../inner_text';
import { EuiCopy } from '../copy';
import { useEuiI18n } from '../i18n';
import { EuiButtonIcon } from '../button';
import { NEW_LINE_REGEX_GLOBAL } from './utils';

/**
 * Hook that returns copy-related state/logic/utils
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var useCopy = function useCopy(_ref) {
  var copyAriaLabel = _ref.copyAriaLabel,
    isCopyable = _ref.isCopyable,
    isVirtualized = _ref.isVirtualized,
    children = _ref.children;
  var _useInnerText = useInnerText(''),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    innerTextRef = _useInnerText2[0],
    _innerText = _useInnerText2[1];
  var innerText = useMemo(function () {
    var _innerText$replace;
    if (!_innerText) return;
    return (_innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    === null || _innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    === void 0 || (_innerText$replace = _innerText
    // remove text that should not be copied (e.g. screen reader instructions)
    .replace(noCopyBoundsRegex, '')
    // Normalize line terminations to match native JS format
    ) === null || _innerText$replace === void 0 || (_innerText$replace = _innerText$replace.replace(NEW_LINE_REGEX_GLOBAL, '\n')
    // remove initial line break (if there was hidden content removed)
    ) === null || _innerText$replace === void 0 || (_innerText$replace = _innerText$replace.replace(/^\n/, '')
    // Reduce two or more consecutive new line characters to a single one
    // This is needed primarily because of how syntax highlighting
    // generated DOM elements affect `innerText` output.
    ) === null || _innerText$replace === void 0 ? void 0 : _innerText$replace.replace(/\n{2,}/g, '\n')) || '';
  }, [_innerText]);
  var textToCopy = isVirtualized ? "".concat(children) : innerText; // Virtualized code blocks do not have inner text

  var showCopyButton = isCopyable && textToCopy;
  var copyDefaultAriaLabel = useEuiI18n('euiCodeBlockCopy.copy', 'Copy');
  var copyButton = useMemo(function () {
    return showCopyButton ? ___EmotionJSX("div", {
      className: "euiCodeBlock__copyButton"
    }, ___EmotionJSX(EuiCopy, {
      textToCopy: textToCopy
    }, function (copy) {
      return ___EmotionJSX(EuiButtonIcon, {
        onClick: copy,
        iconType: "copyClipboard",
        color: "text",
        "aria-label": copyAriaLabel || copyDefaultAriaLabel,
        "data-test-subj": "euiCodeBlockCopy"
      });
    })) : null;
  }, [copyAriaLabel, copyDefaultAriaLabel, showCopyButton, textToCopy]);
  return {
    innerTextRef: innerTextRef,
    copyButton: copyButton
  };
};