import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["style"],
  _excluded2 = ["style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useMemo } from 'react';
import { FixedSizeList } from 'react-window';
import { logicalStyles } from '../../global_styling';
import { EuiAutoSizer } from '../auto_sizer';
import { nodeToHtml } from './utils';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCodeBlockVirtualized = function EuiCodeBlockVirtualized(_ref) {
  var data = _ref.data,
    rowHeight = _ref.rowHeight,
    overflowHeight = _ref.overflowHeight,
    preProps = _ref.preProps,
    codeProps = _ref.codeProps;
  var VirtualizedOuterElement = useMemo(function () {
    return /*#__PURE__*/forwardRef(function (_ref2, ref) {
      var style = _ref2.style,
        props = _objectWithoutProperties(_ref2, _excluded);
      return ___EmotionJSX("pre", _extends({
        style: logicalStyles(style)
      }, props, {
        ref: ref
      }, preProps));
    });
  }, [preProps]);
  var VirtualizedInnerElement = useMemo(function () {
    return /*#__PURE__*/forwardRef(function (_ref3, ref) {
      var style = _ref3.style,
        props = _objectWithoutProperties(_ref3, _excluded2);
      return ___EmotionJSX("code", _extends({
        style: logicalStyles(style)
      }, props, {
        ref: ref
      }, codeProps));
    });
  }, [codeProps]);
  var virtualizationProps = {
    itemData: data,
    itemSize: rowHeight,
    itemCount: data.length,
    outerElementType: VirtualizedOuterElement,
    innerElementType: VirtualizedInnerElement
  };
  return typeof overflowHeight === 'number' ? ___EmotionJSX(EuiAutoSizer, {
    disableHeight: true
  }, function (_ref4) {
    var width = _ref4.width;
    return ___EmotionJSX(FixedSizeList, _extends({
      height: overflowHeight,
      width: width
    }, virtualizationProps), ListRow);
  }) : ___EmotionJSX(EuiAutoSizer, null, function (_ref5) {
    var height = _ref5.height,
      width = _ref5.width;
    return ___EmotionJSX(FixedSizeList, _extends({
      height: height,
      width: width
    }, virtualizationProps), ListRow);
  });
};
var ListRow = function ListRow(_ref6) {
  var data = _ref6.data,
    index = _ref6.index,
    style = _ref6.style;
  var row = data[index];
  row.properties.style = logicalStyles(style);
  return nodeToHtml(row, index, data, 0);
};