import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { createElement } from 'react';
import { listLanguages, highlight } from 'refractor';
import { cx } from '@emotion/css';
import { EuiCodeBlockAnnotation } from './code_block_annotations';
import { euiCodeBlockLineStyles } from './code_block_line.styles';

/**
 * Utils shared between EuiCode and EuiCodeBlock
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SUPPORTED_LANGUAGES = listLanguages();
export var DEFAULT_LANGUAGE = 'text';

/**
 * Platform-agnostic new line regex that safely matches all standard
 * line termination conventions:
 * - LF: Unix-based platforms and JS-native sources like text areas
 * - CRLF: Windows
 * - CR: Mac Classic; to support files saved a long time ago
 */
export var NEW_LINE_REGEX = /\r\n|\r|\n/;

/**
 * Platform-agnostic global new line regex that safely matches all standard
 * line termination conventions.
 * See [NEW_LINE_REGEX]{@link NEW_LINE_REGEX} for more details.
 */
export var NEW_LINE_REGEX_GLOBAL = new RegExp(NEW_LINE_REGEX, 'g');
export var checkSupportedLanguage = function checkSupportedLanguage(language) {
  return SUPPORTED_LANGUAGES.includes(language) ? language : DEFAULT_LANGUAGE;
};
export var getHtmlContent = function getHtmlContent(data, children) {
  if (!Array.isArray(data) || data.length < 1) {
    return children;
  }
  return data.map(nodeToHtml);
};
export var isAstElement = function isAstElement(node) {
  return node.hasOwnProperty('type') && node.type === 'element';
};
export var nodeToHtml = function nodeToHtml(node, idx, nodes) {
  var depth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
  var key = "node-".concat(depth, "-").concat(idx);
  if (isAstElement(node)) {
    var properties = node.properties,
      tagName = node.tagName,
      children = node.children;
    return /*#__PURE__*/createElement(tagName, _objectSpread(_objectSpread({}, properties), {}, {
      key: key,
      className: cx(properties.className)
    }), children && children.map(function (el, i) {
      return (
        // @ts-ignore - using a custom type here to handle JSX annotations
        el.type === 'annotation' ? ___EmotionJSX(EuiCodeBlockAnnotation, {
          className: "euiCodeBlock__lineAnnotation",
          lineNumber: el.lineNumber,
          children: el.annotation,
          key: i
        }) : nodeToHtml(el, i, nodes, depth + 1)
      );
    }));
  }
  return ___EmotionJSX(React.Fragment, {
    key: key
  }, node.value);
};

/**
 * Line utils specific to EuiCodeBlock
 */

// Approximate width of a single digit/character
var CHAR_SIZE = 8;

// Creates an array of numbers from comma-separeated
// string of numbers or number ranges using `-`
// (e.g., "1, 3-10, 15")
export var parseLineRanges = function parseLineRanges(ranges) {
  var highlights = [];
  ranges.replace(/\s/g, '').split(',').forEach(function (line) {
    if (line.includes('-')) {
      var range = line.split('-').map(Number);
      for (var i = range[0]; i <= range[1]; i++) {
        highlights.push(i);
      }
    } else {
      highlights.push(Number(line));
    }
  });
  return highlights;
};
var addLineData = function addLineData(nodes, data) {
  return nodes.reduce(function (result, node) {
    var lineStart = data.lineNumber;
    if (node.type === 'text') {
      if (!node.value.match(NEW_LINE_REGEX)) {
        node.lineStart = lineStart;
        node.lineEnd = lineStart;
        result.push(node);
      } else {
        var lines = node.value.split(NEW_LINE_REGEX);
        lines.forEach(function (line, i) {
          var num = i === 0 ? data.lineNumber : ++data.lineNumber;
          result.push({
            type: 'text',
            value: i === lines.length - 1 ? line : "".concat(line, "\n"),
            lineStart: num,
            lineEnd: num
          });
        });
      }
      return result;
    }
    if (node.children && node.children.length) {
      var _first$lineStart, _last$lineEnd;
      var children = addLineData(node.children, data);
      var first = children[0];
      var last = children[children.length - 1];
      var start = (_first$lineStart = first.lineStart) !== null && _first$lineStart !== void 0 ? _first$lineStart : lineStart;
      var end = (_last$lineEnd = last.lineEnd) !== null && _last$lineEnd !== void 0 ? _last$lineEnd : lineStart;
      if (start !== end) {
        children.forEach(function (node) {
          result.push(node);
        });
      } else {
        node.lineStart = start;
        node.lineEnd = end;
        node.children = children;
        result.push(node);
      }
      return result;
    }
    result.push(node);
    return result;
  }, []);
};
function wrapLines(nodes, options, euiTheme) {
  var grouped = [];
  nodes.forEach(function (node) {
    var lineStart = node.lineStart - 1;
    if (grouped[lineStart]) {
      grouped[lineStart].push(node);
    } else {
      grouped[lineStart] = [node];
    }
  });
  var wrapped = [];
  grouped.forEach(function (node, i) {
    var children = node;
    var styles = euiCodeBlockLineStyles(euiTheme);
    var lineStyles = cx([styles.euiCodeBlock__line, options.showLineNumbers && styles.hasLineNumbers]);
    if (options.showLineNumbers) {
      var _options$annotations;
      var lineNumber = i + 1;
      var digits = grouped.length.toString().length;
      var width = digits * CHAR_SIZE;

      // Line text element and highlights
      var highlights = options.highlight ? parseLineRanges(options.highlight) : [];
      var lineTextStyles = cx([styles.lineText.euiCodeBlock__lineText, highlights.includes(lineNumber) && styles.lineText.isHighlighted]);
      var lineTextElement = {
        type: 'element',
        tagName: 'span',
        properties: {
          className: ['euiCodeBlock__lineText', lineTextStyles]
        },
        children: node
      };

      // Line number column/wrapper
      var lineNumberWrapperStyles = cx(styles.lineNumber.euiCodeBlock__lineNumberWrapper);
      var lineNumberWrapperElement = {
        type: 'element',
        tagName: 'span',
        properties: {
          style: {
            inlineSize: width
          },
          className: ['euiCodeBlock__lineNumberWrapper', lineNumberWrapperStyles]
        },
        children: []
      };

      // Line number element
      var lineNumberStyles = cx(styles.lineNumber.euiCodeBlock__lineNumber);
      var lineNumberElement = {
        type: 'element',
        tagName: 'span',
        properties: _defineProperty(_defineProperty({
          className: ['euiCodeBlock__lineNumber', lineNumberStyles]
        }, 'data-line-number', lineNumber), 'aria-hidden', true),
        children: []
      };
      lineNumberWrapperElement.children.push(lineNumberElement);

      // Annotation element
      var hasAnnotation = (_options$annotations = options.annotations) === null || _options$annotations === void 0 ? void 0 : _options$annotations.hasOwnProperty(lineNumber);
      if (hasAnnotation) {
        var annotationElement = {
          type: 'annotation',
          annotation: options.annotations[lineNumber],
          lineNumber: lineNumber
        };
        lineNumberWrapperElement.children.push(annotationElement);
      }
      children = [lineNumberWrapperElement, lineTextElement];
    }
    wrapped.push({
      type: 'element',
      tagName: 'span',
      properties: {
        className: ['euiCodeBlock__line', lineStyles]
      },
      children: children
    });
  });
  return wrapped;
}
export var highlightByLine = function highlightByLine(children, language, data, euiTheme) {
  return wrapLines(addLineData(highlight(children, language), {
    lineNumber: data.start
  }), {
    showLineNumbers: data.show,
    highlight: data.highlight,
    annotations: data.annotations
  }, euiTheme);
};