import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["id", "children", "className", "isDocked", "isOpen", "button", "showButtonIfDocked", "dockedBreakpoint", "as", "size", "side", "ownFocus", "outsideClickCloses", "closeButtonPosition", "paddingSize", "focusTrapProps"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { cloneElement, useRef } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, useGeneratedHtmlId, useIsWithinMinBreakpoint, useCombinedRefs } from '../../services';
import { EuiFlyout } from '../flyout';
import { euiCollapsibleNavStyles } from './collapsible_nav.styles';

// Extend all the flyout props except `onClose` because we handle this internally
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsibleNav = function EuiCollapsibleNav(_ref) {
  var id = _ref.id,
    children = _ref.children,
    className = _ref.className,
    _ref$isDocked = _ref.isDocked,
    isDocked = _ref$isDocked === void 0 ? false : _ref$isDocked,
    _ref$isOpen = _ref.isOpen,
    isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
    button = _ref.button,
    _ref$showButtonIfDock = _ref.showButtonIfDocked,
    showButtonIfDocked = _ref$showButtonIfDock === void 0 ? false : _ref$showButtonIfDock,
    _ref$dockedBreakpoint = _ref.dockedBreakpoint,
    dockedBreakpoint = _ref$dockedBreakpoint === void 0 ? 'l' : _ref$dockedBreakpoint,
    _ref$as = _ref.as,
    as = _ref$as === void 0 ? 'nav' : _ref$as,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 320 : _ref$size,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'left' : _ref$side,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
    _ref$outsideClickClos = _ref.outsideClickCloses,
    outsideClickCloses = _ref$outsideClickClos === void 0 ? true : _ref$outsideClickClos,
    _ref$closeButtonPosit = _ref.closeButtonPosition,
    closeButtonPosition = _ref$closeButtonPosit === void 0 ? 'outside' : _ref$closeButtonPosit,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$focusTrapProps = _ref.focusTrapProps,
    _focusTrapProps = _ref$focusTrapProps === void 0 ? {} : _ref$focusTrapProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var flyoutID = useGeneratedHtmlId({
    conditionalId: id,
    suffix: 'euiCollapsibleNav'
  });
  var buttonRef = useRef();
  var combinedButtonRef = useCombinedRefs([button === null || button === void 0 ? void 0 : button.props.ref, buttonRef]);
  var focusTrapProps = _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
    shards: [buttonRef].concat(_toConsumableArray(_focusTrapProps.shards || []))
  });
  var windowIsLargeEnoughToPush = useIsWithinMinBreakpoint(dockedBreakpoint);
  var navIsDocked = isDocked && windowIsLargeEnoughToPush;
  var flyoutType = navIsDocked ? 'push' : 'overlay';
  var classes = classNames('euiCollapsibleNav', className);
  var styles = useEuiMemoizedStyles(euiCollapsibleNavStyles);
  var cssStyles = [styles.euiCollapsibleNav, styles[flyoutType]];

  // Show a trigger button if one was passed but
  // not if navIsDocked and showButtonIfDocked is false
  var trigger = navIsDocked && !showButtonIfDocked ? undefined : button && /*#__PURE__*/cloneElement(button, {
    'aria-controls': flyoutID,
    'aria-expanded': isOpen,
    'aria-pressed': isOpen,
    // When EuiOutsideClickDetector is enabled, we don't want both the toggle button and document touches/clicks to happen, they'll cancel eachother out
    onTouchEnd: function onTouchEnd(e) {
      e.nativeEvent.stopImmediatePropagation();
    },
    onMouseUpCapture: function onMouseUpCapture(e) {
      e.nativeEvent.stopImmediatePropagation();
    },
    ref: combinedButtonRef
  });
  var flyout = ___EmotionJSX(EuiFlyout, _extends({
    id: flyoutID,
    css: cssStyles,
    className: classes
    // Flyout props we set different defaults for
    ,
    as: as,
    size: size,
    side: side,
    ownFocus: ownFocus,
    outsideClickCloses: outsideClickCloses,
    closeButtonPosition: closeButtonPosition,
    paddingSize: paddingSize,
    focusTrapProps: focusTrapProps
  }, rest, {
    // Props dependent on internal docked status
    type: flyoutType,
    hideCloseButton: navIsDocked,
    pushMinBreakpoint: dockedBreakpoint
  }), children);
  return ___EmotionJSX(React.Fragment, null, trigger, (isOpen || navIsDocked) && flyout);
};