/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
export var euiCollapsibleNavStyles = function euiCollapsibleNavStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiCollapsibleNav: /*#__PURE__*/css(";label:euiCollapsibleNav;"),
    // The majority of styles extend from EuiFlyout
    push: /*#__PURE__*/css(";label:push;"),
    // No z-index needed
    overlay: /*#__PURE__*/css("z-index:", euiTheme.levels.navigation, ";;label:overlay;")
  };
};