import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["title", "icon", "solutions", "items", "className"],
  _excluded2 = ["title", "icon", "isSecondary"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext, useState, useMemo, useCallback } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { useEuiI18n } from '../../i18n';
import { EuiIcon } from '../../icon';
import { EuiInputPopover, EuiPopoverTitle } from '../../popover';
import { EuiListGroup } from '../../list_group';
import { EuiCollapsibleNavContext } from '../context';
import { EuiCollapsibleNavLink } from '../collapsible_nav_item/collapsible_nav_link';
import { EuiCollapsibleNavSubItems } from '../collapsible_nav_item/collapsible_nav_item';
import { EuiCollapsedNavPopover } from '../collapsible_nav_item/collapsed/collapsed_nav_popover';
import { euiCollapsibleNavKibanaSolutionStyles } from './collapsible_nav_kibana_solution.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * This component should only ever be used as a **top-level component**.
 * It also should **not** be used in the nav footer.
 *
 * This component is **very** specific to Kibana and is not meant to be a generic component.
 */
export var KibanaCollapsibleNavSolution = function KibanaCollapsibleNavSolution(_ref) {
  var title = _ref.title,
    icon = _ref.icon,
    _ref$solutions = _ref.solutions,
    solutions = _ref$solutions === void 0 ? [] : _ref$solutions,
    items = _ref.items,
    className = _ref.className,
    props = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiCollapsibleNavContext),
    isCollapsed = _useContext.isCollapsed,
    isPush = _useContext.isPush;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isSolutionSwitcherOpen = _useState2[0],
    setIsSolutionSwitcherOpen = _useState2[1];
  var classes = classNames('kibanaCollapsibleNavSolution', className);
  var styles = useEuiMemoizedStyles(euiCollapsibleNavKibanaSolutionStyles);
  var cssStyles = [styles.euiCollapsibleNavKibanaSolution, isPush && isCollapsed ? styles.collapsed : styles.uncollapsed];
  var solutionSwitcherIcon = 'layers';
  var solutionSolutionSwitcherTitle = useEuiI18n('euiCollapsibleNavKibanaSolution.switcherTitle', 'Solution view');
  var solutionSolutionSwitcherAriaLabel = useEuiI18n('euiCollapsibleNavKibanaSolution.switcherAriaLabel', ' - click to switch to another solution');
  var solutionSolutionGroupLabel = useEuiI18n('euiCollapsibleNavKibanaSolution.groupLabel', 'Navigate to solution');
  var closeSolutionPopover = useCallback(function (event) {
    var _childItem$firstEleme;
    // Allow child items to stop the popover from being closed
    if (event.isPropagationStopped()) return;
    // Only listen for clicks on child items - currentTarget is the parent <ul>
    if (event.target === event.currentTarget) return;

    // Only close the popover if the item is a clickable link or button
    var target = event.target;
    var childItem = target.closest('.euiListGroupItem');
    if (['A', 'BUTTON'].includes((childItem === null || childItem === void 0 || (_childItem$firstEleme = childItem.firstElementChild) === null || _childItem$firstEleme === void 0 ? void 0 : _childItem$firstEleme.tagName) || '')) {
      setIsSolutionSwitcherOpen(false);
    }
  }, []);
  var solutionSwitcherContent = useMemo(function () {
    var _parseListItems = parseListItems(solutions),
      _parseListItems2 = _slicedToArray(_parseListItems, 2),
      primaryItems = _parseListItems2[0],
      secondaryItems = _parseListItems2[1];
    return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiListGroup, {
      "data-test-subj": "kibanaSolutionSwitcherList",
      "aria-label": solutionSolutionGroupLabel,
      listItems: primaryItems,
      size: "s",
      bordered: true,
      onClick: closeSolutionPopover
    }), secondaryItems.length > 0 && ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiListGroup, {
      listItems: secondaryItems,
      size: "s",
      css: styles.euiCollapsibleNavKibanaSolution__secondaryItems,
      onClick: closeSolutionPopover
    })));
  }, [solutions, solutionSolutionGroupLabel, closeSolutionPopover, styles]);
  var sharedPopoverProps = {
    'aria-label': solutionSolutionSwitcherTitle,
    panelProps: {
      css: styles.euiCollapsibleNavKibanaSolution__switcherPopover
    },
    panelPaddingSize: 's',
    display: 'block'
  };
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles
  }, props), isCollapsed && isPush ? ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiCollapsedNavPopover, {
    icon: icon,
    title: title,
    items: items
  }), ___EmotionJSX(EuiCollapsedNavPopover, _extends({}, sharedPopoverProps, {
    icon: solutionSwitcherIcon,
    title: solutionSolutionSwitcherTitle,
    items: [{
      renderItem: function renderItem() {
        return solutionSwitcherContent;
      }
    }],
    "data-test-subj": "kibanaSolutionSwitcherDocked"
  }))) : ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiInputPopover, _extends({}, sharedPopoverProps, {
    fullWidth: true
    // Use the default EuiPopover focus trap, not the EuiInputPopover focus trap
    ,
    disableFocusTrap: true,
    ownFocus: true,
    isOpen: isSolutionSwitcherOpen,
    closePopover: function closePopover() {
      return setIsSolutionSwitcherOpen(false);
    },
    input: ___EmotionJSX(EuiCollapsibleNavLink, {
      css: styles.euiCollapsibleNavKibanaSolution__title,
      onClick: function onClick() {
        return setIsSolutionSwitcherOpen(function (isOpen) {
          return !isOpen;
        });
      },
      isInteractive: true,
      isSelected: isSolutionSwitcherOpen,
      "data-test-subj": "kibanaSolutionSwitcher"
    }, ___EmotionJSX(EuiIcon, {
      type: icon,
      css: styles.euiCollapsibleNavKibanaSolution__logo
    }), title, ___EmotionJSX(EuiIcon, {
      type: solutionSwitcherIcon,
      css: styles.euiCollapsibleNavKibanaSolution__switcherIcon,
      "aria-label": solutionSolutionSwitcherAriaLabel
    }))
  }), ___EmotionJSX(EuiPopoverTitle, null, solutionSolutionSwitcherTitle), solutionSwitcherContent), ___EmotionJSX(EuiCollapsibleNavSubItems, {
    items: items,
    role: "group",
    "aria-label": title
  })));
};

/**
 * Tweak EuiListGroup's items API to match EuiCollapsibleNav's
 * more closely (primarily label->title, iconType->icon),
 * and also to allow passing secondary items in the same array
 * (which will get rendered in a separate non-bordered group)
 */

var parseListItems = function parseListItems(items) {
  var primaryItems = [];
  var secondaryItems = [];
  items.forEach(function (_ref2) {
    var title = _ref2.title,
      icon = _ref2.icon,
      isSecondary = _ref2.isSecondary,
      item = _objectWithoutProperties(_ref2, _excluded2);
    var arrayToPushTo = isSecondary ? secondaryItems : primaryItems;
    arrayToPushTo.push(_objectSpread(_objectSpread({}, item), {}, {
      label: title,
      iconType: icon
    }));
  });
  return [primaryItems, secondaryItems];
};