import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className"],
  _excluded2 = ["className", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiFlyoutBody, EuiFlyoutFooter } from '../flyout';
import { EuiCollapsibleNavContext } from './context';
import { euiCollapsibleNavBodyStyles as bodyStyles, euiCollapsibleNavFooterStyles } from './collapsible_nav_body_footer.styles';

/**
 * These components are incredibly light wrappers around `EuiFlyoutBody`
 * and `EuiFlyoutFooter` with collapsible nav-specific styling/considerations.
 *
 * Note: They are not intended to be used standalone outside of EuiCollapsibleNav
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsibleNavBody = function EuiCollapsibleNavBody(_ref) {
  var className = _ref.className,
    props = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCollapsibleNav__body', className);
  var _useContext = useContext(EuiCollapsibleNavContext),
    isCollapsed = _useContext.isCollapsed,
    isPush = _useContext.isPush;
  var cssStyles = [bodyStyles.euiCollapsibleNav__body, isCollapsed && isPush && bodyStyles.isPushCollapsed];
  return ___EmotionJSX(EuiFlyoutBody, _extends({
    className: classes,
    css: cssStyles
    // Since this is a nav, we can almost guarantee there will be clickable
    // children/links that will enable scrolling. As such, we're optimistically
    // removing the extra tab stop
    ,
    scrollableTabIndex: -1
  }, props));
};
export var EuiCollapsibleNavFooter = function EuiCollapsibleNavFooter(_ref2) {
  var className = _ref2.className,
    children = _ref2.children,
    props = _objectWithoutProperties(_ref2, _excluded2);
  var classes = classNames('euiCollapsibleNav__footer', className);
  var _useContext2 = useContext(EuiCollapsibleNavContext),
    isCollapsed = _useContext2.isCollapsed,
    isPush = _useContext2.isPush;
  var styles = useEuiMemoizedStyles(euiCollapsibleNavFooterStyles);
  var cssStyles = styles.euiCollapsibleNav__footer;
  var overflowWrapperStyles = [styles.euiFlyoutFooter__overflow, isCollapsed && isPush && styles.isPushCollapsed];
  return ___EmotionJSX(EuiFlyoutFooter, _extends({
    className: classes,
    css: cssStyles
  }, props), ___EmotionJSX("div", {
    css: overflowWrapperStyles
  }, children));
};