import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "css"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useContext } from 'react';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiButtonIcon } from '../../button';
import { useEuiI18n } from '../../i18n';
import { EuiCollapsibleNavContext } from '../context';
import { euiCollapsibleNavButtonWrapperStyles } from './collapsible_nav_button.styles';
import classNames from 'classnames';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsibleNavButton = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var className = _ref.className,
    css = _ref.css,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiCollapsibleNavContext),
    side = _useContext.side,
    isPush = _useContext.isPush,
    isCollapsed = _useContext.isCollapsed,
    isOverlayOpen = _useContext.isOverlayOpen;
  var styles = useEuiMemoizedStyles(euiCollapsibleNavButtonWrapperStyles);
  var cssStyles = [styles.euiCollapsibleNavButtonWrapper, styles[side]];
  var buttonStyles = [styles.euiCollapsibleNavButton, css];
  var classes = classNames('euiCollapsibleNavButton', className);
  var toggleExpandLabel = useEuiI18n('euiCollapsibleNavButton.ariaLabelExpand', 'Expand navigation');
  var toggleCollapseLabel = useEuiI18n('euiCollapsibleNavButton.ariaLabelCollapse', 'Collapse navigation');
  var toggleOpenLabel = useEuiI18n('euiCollapsibleNavButton.ariaLabelOpen', 'Open navigation');
  var toggleCloseLabel = useEuiI18n('euiCollapsibleNavButton.ariaLabelClose', 'Close navigation');
  var ariaLabel;
  var iconType;
  if (isPush) {
    ariaLabel = isCollapsed ? toggleExpandLabel : toggleCollapseLabel;
    if (side === 'left') {
      iconType = isCollapsed ? 'menuRight' : 'menuLeft';
    } else {
      iconType = isCollapsed ? 'menuLeft' : 'menuRight';
    }
  } else {
    ariaLabel = isOverlayOpen ? toggleCloseLabel : toggleOpenLabel;
    iconType = isOverlayOpen ? 'cross' : 'menu';
  }
  return ___EmotionJSX("div", {
    className: "euiCollapsibleNavButtonWrapper",
    css: cssStyles,
    ref: ref
  }, ___EmotionJSX(EuiButtonIcon, _extends({
    "data-test-subj": "euiCollapsibleNavButton",
    className: classes,
    css: buttonStyles,
    size: "s",
    color: "text",
    iconType: iconType,
    "aria-label": ariaLabel,
    "aria-pressed": isPush ? !isCollapsed : isOverlayOpen,
    "aria-expanded": isPush ? !isCollapsed : isOverlayOpen
  }, rest)));
});
EuiCollapsibleNavButton.displayName = 'EuiCollapsibleNavButton';