import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["href", "title", "icon", "iconProps", "isSelected", "onClick", "hideToolTip", "linkProps", "titleElement"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../../services';
import { EuiButtonIcon } from '../../../button/button_icon';
import { EuiToolTip } from '../../../tool_tip';
import { EuiCollapsibleNavContext } from '../../context';
import { euiCollapsedNavButtonStyles, euiCollapsedNavItemTooltipStyles } from './collapsed_nav_button.styles';
import { useEuiI18n } from '../../../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsedNavButton = function EuiCollapsedNavButton(_ref) {
  var href = _ref.href,
    title = _ref.title,
    icon = _ref.icon,
    iconProps = _ref.iconProps,
    isSelected = _ref.isSelected,
    onClick = _ref.onClick,
    hideToolTip = _ref.hideToolTip,
    linkProps = _ref.linkProps,
    titleElement = _ref.titleElement,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiCollapsibleNavContext),
    side = _useContext.side;
  var buttonStyles = useEuiMemoizedStyles(euiCollapsedNavButtonStyles);
  var buttonCssStyles = [buttonStyles.euiCollapsedNavButton, isSelected && buttonStyles.isSelected, linkProps === null || linkProps === void 0 ? void 0 : linkProps.css];
  var buttonClassName = classNames('euiCollapsedNavButton', linkProps === null || linkProps === void 0 ? void 0 : linkProps.className);
  var tooltipStyles = useEuiMemoizedStyles(euiCollapsedNavItemTooltipStyles);
  var tooltipCssStyles = [tooltipStyles.euiCollapsedNavItemTooltip, tooltipStyles[side], hideToolTip && tooltipStyles.hidden];
  var buttonIconAriaLabel = useEuiI18n('euiCollapsedNavButton.ariaLabelButtonIcon', '{title}, quick navigation menu', {
    title: title
  });
  return ___EmotionJSX(EuiToolTip, {
    content: title,
    css: tooltipCssStyles,
    position: side,
    display: "block",
    anchorProps: rest,
    repositionOnScroll: true
  }, ___EmotionJSX(EuiButtonIcon, _extends({
    "data-test-subj": "euiCollapsedNavButton",
    size: "s",
    color: "text",
    href: href,
    onClick: onClick,
    "aria-label": buttonIconAriaLabel
  }, linkProps, {
    // Exclusive union shenanigans
    className: buttonClassName,
    css: buttonCssStyles,
    iconType: icon || 'link',
    iconSize: iconProps === null || iconProps === void 0 ? void 0 : iconProps.size,
    isSelected: isSelected
  })));
};