function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../../global_styling';
import { euiCollapsibleNavItemVariables } from '../collapsible_nav_item.styles';
export var euiCollapsedNavButtonStyles = function euiCollapsedNavButtonStyles(euiThemeContext) {
  var sharedStyles = euiCollapsibleNavItemVariables(euiThemeContext);
  return {
    euiCollapsedNavButton: /*#__PURE__*/css("display:flex;margin:", sharedStyles.padding, ";&.euiButtonIcon:hover{transform:none;};label:euiCollapsedNavButton;"),
    isSelected: /*#__PURE__*/css("&,&:hover,&:focus{background-color:", sharedStyles.backgroundSelectedColor, ";};label:isSelected;")
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1mkqgn7-hidden",
  styles: "display:none;label:hidden;"
} : {
  name: "1mkqgn7-hidden",
  styles: "display:none;label:hidden;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiCollapsedNavItemTooltipStyles = function euiCollapsedNavItemTooltipStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiCollapsedNavItemTooltip: /*#__PURE__*/css(";label:euiCollapsedNavItemTooltip;"),
    // Bring the tooltip closer to the nav - it's a little too far otherwise
    left: /*#__PURE__*/css(logicalCSS('margin-left', "-".concat(euiTheme.size.m)), ";;label:left;"),
    right: /*#__PURE__*/css(logicalCSS('margin-right', "-".concat(euiTheme.size.m)), ";;label:right;"),
    // If the item has a popover and the popover is open, we don't want the
    // tooltip to appear if so - the popover already renders the item title
    hidden: _ref
  };
};