import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "href", "linkProps", "items", "accordionProps", "isCollapsible"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { EuiCollapsedNavButton } from './collapsed_nav_button';
import { EuiCollapsedNavPopover } from './collapsed_nav_popover';
import classNames from 'classnames';

/**
 * The collapsed nav item state only shows on larger/non-mobile screens
 * and collapses top-level link/accordion items to only rendering icons.
 *
 * Accordions turn into popovers, links turn into icon buttons
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsedNavItem = function EuiCollapsedNavItem(_ref) {
  var className = _ref.className,
    href = _ref.href,
    linkProps = _ref.linkProps,
    items = _ref.items,
    accordionProps = _ref.accordionProps,
    isCollapsible = _ref.isCollapsible,
    props = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCollapsedNavItem', className);
  return items ? ___EmotionJSX(EuiCollapsedNavPopover, _extends({
    items: items,
    className: classes
  }, props)) : ___EmotionJSX(EuiCollapsedNavButton, _extends({
    href: href,
    linkProps: linkProps,
    className: classes
  }, props));
};