import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["items", "title", "titleElement", "icon", "iconProps", "isSelected"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useCallback, useContext } from 'react';
import { useEuiMemoizedStyles } from '../../../../services';
import { EuiPopover, EuiPopoverTitle } from '../../../popover';
import { EuiCollapsibleNavContext } from '../../context';
import { EuiCollapsibleNavSubItem } from '../collapsible_nav_item';
import { EuiCollapsedNavButton } from './collapsed_nav_button';
import { euiCollapsedNavPopoverStyles } from './collapsed_nav_popover.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsedNavPopover = function EuiCollapsedNavPopover(_ref) {
  var _rest$panelProps;
  var items = _ref.items,
    title = _ref.title,
    _ref$titleElement = _ref.titleElement,
    TitleElement = _ref$titleElement === void 0 ? 'span' : _ref$titleElement,
    icon = _ref.icon,
    iconProps = _ref.iconProps,
    isSelected = _ref.isSelected,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiCollapsedNavPopoverStyles);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var togglePopover = useCallback(function () {
    return setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = useCallback(function () {
    return setIsPopoverOpen(false);
  }, []);
  var closePopoverClick = useCallback(function (event) {
    closePopover();
    // Visually hide the tooltip for mouse users only
    var isMouseEvent = event.screenX !== 0 && event.screenY !== 0;
    if (isMouseEvent) setIsTooltipHidden(true);
  }, [closePopover]);
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isTooltipHidden = _useState4[0],
    setIsTooltipHidden = _useState4[1];
  var reshowTooltip = useCallback(function () {
    return setIsTooltipHidden(false);
  }, []);
  var navContext = useContext(EuiCollapsibleNavContext);
  return ___EmotionJSX(EuiPopover, _extends({
    closePopover: closePopover,
    isOpen: isPopoverOpen,
    display: "block",
    anchorPosition: "rightUp",
    panelPaddingSize: "none",
    repositionOnScroll: true,
    button: ___EmotionJSX(EuiCollapsedNavButton, {
      title: title,
      icon: icon || 'boxesHorizontal',
      iconProps: iconProps,
      isSelected: isSelected,
      onClick: togglePopover,
      hideToolTip: isPopoverOpen || isTooltipHidden,
      linkProps: {
        onMouseOver: reshowTooltip
      }
    })
  }, rest, {
    panelProps: _objectSpread(_objectSpread({}, rest.panelProps), {}, {
      css: [styles.euiCollapsedNavPopover__panel, (_rest$panelProps = rest.panelProps) === null || _rest$panelProps === void 0 ? void 0 : _rest$panelProps.css]
    })
  }), ___EmotionJSX(EuiPopoverTitle, null, ___EmotionJSX(TitleElement, {
    css: styles.euiCollapsedNavPopover__title,
    className: "eui-textTruncate"
  }, title)), ___EmotionJSX("div", {
    css: styles.euiCollapsedNavPopover__items
  }, ___EmotionJSX(EuiCollapsibleNavContext.Provider, {
    value: _objectSpread(_objectSpread({}, navContext), {}, {
      closePortals: closePopoverClick
    })
  }, items.map(function (item, index) {
    return ___EmotionJSX(EuiCollapsibleNavSubItem, _extends({
      key: index
    }, item));
  }))));
};