import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["id", "className", "items", "isSubItem", "isSelected", "accordionProps", "buttonContent", "children"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, useGeneratedHtmlId } from '../../../services';
import { EuiAccordion } from '../../accordion';
import { EuiCollapsibleNavSubItems } from './collapsible_nav_item';
import { EuiCollapsibleNavLink } from './collapsible_nav_link';
import { euiCollapsibleNavAccordionStyles } from './collapsible_nav_accordion.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Internal nav accordion component.
 *
 * Renders children as either a nav link or any number/nesting of more nav accordions.
 * Triggering the open/closed state is handled only by the accordion `arrow` for
 * UX consistency, as accordion/nav titles can be their own links to pages.
 */
export var EuiCollapsibleNavAccordion = function EuiCollapsibleNavAccordion(_ref) {
  var _accordionProps$arrow;
  var id = _ref.id,
    className = _ref.className,
    items = _ref.items,
    isSubItem = _ref.isSubItem,
    isSelected = _ref.isSelected,
    accordionProps = _ref.accordionProps,
    buttonContent = _ref.buttonContent,
    _children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCollapsibleNavAccordion', className);
  var groupID = useGeneratedHtmlId({
    conditionalId: id
  });
  var styles = useEuiMemoizedStyles(euiCollapsibleNavAccordionStyles);
  var cssStyles = [styles.euiCollapsibleNavAccordion, isSubItem ? styles.isSubItem : styles.isTopItem, isSelected && styles.isSelected, accordionProps === null || accordionProps === void 0 ? void 0 : accordionProps.css];
  return ___EmotionJSX(EuiAccordion, _extends({
    id: groupID,
    className: classes,
    initialIsOpen: isSelected,
    buttonContent: ___EmotionJSX(EuiCollapsibleNavLink, {
      isSelected: isSelected,
      isSubItem: isSubItem,
      isInteractive: false
    }, buttonContent),
    arrowDisplay: "right"
  }, rest, accordionProps, {
    css: cssStyles,
    arrowProps: _objectSpread(_objectSpread({
      iconSize: 's'
    }, accordionProps === null || accordionProps === void 0 ? void 0 : accordionProps.arrowProps), {}, {
      css: [styles.euiCollapsibleNavAccordion__arrow, accordionProps === null || accordionProps === void 0 || (_accordionProps$arrow = accordionProps.arrowProps) === null || _accordionProps$arrow === void 0 ? void 0 : _accordionProps$arrow.css]
    })
  }), ___EmotionJSX(EuiCollapsibleNavSubItems, {
    items: items,
    isSubItem: isSubItem,
    className: "euiCollapsibleNavAccordion__children"
  }));
};