import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "header", "items", "isSubItem", "isSelected", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, useGeneratedHtmlId } from '../../../services';
import { EuiCollapsibleNavSubItems } from './collapsible_nav_item';
import { euiCollapsibleNavItemVariables } from './collapsible_nav_item.styles';
import { EuiCollapsibleNavLink } from './collapsible_nav_link';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Internal nav group. Should look the same as an open accordion,
 * but not be toggle-able to close.
 *
 * Yes, I know this is the 3rd component in EUI named EuiCollapsibleNavGroup :|
 * I'm waiting for serverless's design architecture to settle before untangling
 * this pasghetti
 */
export var EuiCollapsibleNavGroup = function EuiCollapsibleNavGroup(_ref) {
  var className = _ref.className,
    header = _ref.header,
    items = _ref.items,
    isSubItem = _ref.isSubItem,
    isSelected = _ref.isSelected,
    _children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCollapsibleNavGroup', className);
  var sharedStyles = useEuiMemoizedStyles(euiCollapsibleNavItemVariables);
  var cssStyles = !isSubItem ? {
    css: {
      margin: sharedStyles.padding,
      label: 'euiCollapsibleNavGroup-isTopItem'
    }
  } : undefined; // Prevents Emotion from generating a selector if no styles need to be applied

  var labelledById = useGeneratedHtmlId();
  return ___EmotionJSX("div", _extends({
    className: classes
  }, cssStyles, rest), ___EmotionJSX(EuiCollapsibleNavLink, {
    id: labelledById,
    isSelected: isSelected,
    isSubItem: isSubItem,
    isInteractive: false
  }, header), ___EmotionJSX(EuiCollapsibleNavSubItems, {
    items: items,
    isSubItem: isSubItem,
    className: "euiCollapsibleNavGroup__children",
    role: "group",
    "aria-labelledby": labelledById
  }));
};